﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace ElfLibrary
{
    using System;

    public enum ElfDynamicArrayTag
    {
        DT_NULL = 0,
        DT_NEEDED = 1,
        DT_PLTRELSZ = 2,
        DT_PLTGOT = 3,
        DT_HASH = 4,
        DT_STRTAB = 5,
        DT_SYMTAB = 6,
        DT_RELA = 7,
        DT_RELASZ = 8,
        DT_RELAENT = 9,
        DT_STRSZ = 10,
        DT_SYMENT = 11,
        DT_INIT = 12,
        DT_FINI = 13,
        DT_SONAME = 14,
        DT_RPATH = 15,
        DT_SYMBOLIC = 16,
        DT_REL = 17,
        DT_RELSZ = 18,
        DT_RELENT = 19,
        DT_PLTREL = 20,
        DT_DEBUG = 21,
        DT_TEXTREL = 22,
        DT_JMPREL = 23,
        DT_BIND_NOW = 24,
        DT_INIT_ARRAY = 25,
        DT_FINI_ARRAY = 26,
        DT_INIT_ARRAYSZ = 27,
        DT_FINI_ARRAYSZ = 28,
        DT_LOOS = 0x60000000,
        DT_HIOS = 0x6fffffff,
        DT_LOPROC = 0x70000000,
        DT_HIPROC = 0x7fffffff,
    }

    /// <summary>
    /// Elf DynamicSection のベースクラス
    /// </summary>
    public abstract class ElfDynamicSection : IElfFile
    {
        public long D_Tag { get; set; }
        // unionで定義されている
        // union {
        //   Elf64_Xword d_val;
        //   Elf64_Addr d_ptr;
        // } d_un;
        public ulong D_Un { get; set; }

        /// <summary>
        /// ファイルから Dynamic Section を読み込みます。
        /// </summary>
        /// <param name="reader">読み込みインスタンス</param>
        public abstract void ReadElfFile(ElfBinaryReader reader);

        /// <summary>
        /// ファイルに Dynamic Section を書き込みます。
        /// </summary>
        /// <param name="writer">書き込みインスタンス</param>
        public abstract void WriteElfData(ElfBinaryWriter writer);
    }
}
