﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace ElfLibrary.Elf64
{
    using System;
    using System.IO;

    /// <summary>
    /// ELF 64bit Symbol Table のヘッダ
    /// </summary>
    public class Elf64SymbolTableEntry : ElfSymbolTableEntry
    {
        public const ushort Elf64HeaderSize = 24;

        /// <summary>
        /// ファイルから SymbolHeader を読み込みます。
        /// </summary>
        /// <param name="reader">読み込みインスタンス</param>
        public override void ReadElfFile(ElfBinaryReader reader)
        {
            Name = reader.ReadUInt32();
            Info = reader.ReadByte();
            Other = reader.ReadByte();
            SectionIndex = reader.ReadUInt16();
            Value = reader.ReadUInt64();
            Size = reader.ReadUInt64();
        }

        /// <summary>
        /// ファイルに SymbolHeader を書き込みます。
        /// </summary>
        /// <param name="writer">書き込みインスタンス</param>
        public override void WriteElfData(ElfBinaryWriter writer)
        {
            writer.WriteUInt32(Name);
            writer.WriteByte(Info);
            writer.WriteByte(Other);
            writer.WriteUInt16(SectionIndex);
            writer.WriteUInt64(Value);
            writer.WriteUInt64(Size);
        }
    }
}
