﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace ElfLibrary.Elf32
{
    using System;

    /// <summary>
    /// Elf 32-bit ElfRelocationEntry/ ElfRelocationAddendEntry
    /// のフィールド変数を操作するためのメソッドを集めたクラス
    /// </summary>
    public static class Elf32RelocationEntryOperation
    {
        /// <summary>
        /// r_info からシンボルのインデックス情報を取得します。
        /// </summary>
        /// <param name="i">r_info</param>
        /// <returns>シンボルのインデックス</returns>
        public static uint GetSymbolIndex(uint i)
        {
            return i >> 8;
        }

        /// <summary>
        /// r_info からリロケーションの種類を取得します。
        /// </summary>
        /// <param name="i">r_info</param>
        /// <returns>リロケーションの種類</returns>
        public static ElfRelocationType GetSymbolType(uint i)
        {
            return NumericConvert.IntToElfDefine<ElfRelocationType>((byte)i);
        }

        /// <summary>
        /// シンボルのインデックスとリロケーションの種類から r_info を作成します。
        /// </summary>
        /// <param name="sym">シンボルのインデックス</param>
        /// <param name="type">リロケーションの種類</param>
        /// <returns></returns>
        public static uint MakeInfo(uint sym, ElfRelocationType type)
        {
            return sym << 8 + (byte)type;
        }
    }
}
