﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>

#include <nn/fssystem/fs_AsynchronousAccess.h>
#include "BufferPool.h"

namespace Nintendo { namespace Authoring { namespace FileSystemMetaLibrary {

    namespace {
        const auto DeviceBufferSize = 8 * 1024 * 1024;
        NN_ALIGNAS(nn::fssystem::BufferPoolAlignment) char g_DeviceBuffer[DeviceBufferSize];
        auto g_IsBufferPoolInitialized = false;
    }

    void EnsureBufferPool() NN_NOEXCEPT
    {
        if( !g_IsBufferPoolInitialized )
        {
            NN_ABORT_UNLESS(nn::fssystem::InitializeBufferPool(g_DeviceBuffer, DeviceBufferSize).IsSuccess());
            g_IsBufferPoolInitialized = true;
        }
    }

}}}
