﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "HsmInterfaceManager.h"
#include "IHashCalculator.h"

namespace Nintendo { namespace Authoring { namespace CryptoLibrary {

using namespace System;

    public ref class HsmHmacSha256HashCryptoDriver : IHashCalculator
    {
    public:
        property int KeySize
        {
            virtual int get() { return 32; }
        }

        property int HashSize
        {
            virtual int get() { return 32; }
        }

        HsmHmacSha256HashCryptoDriver(HmacSha256KeyIndex keyIndex)
        {
            m_HsmInterface = gcnew HsmInterface();
            m_HsmKeyIndex = keyIndex;
            GC::KeepAlive(this);
        }

        ~HsmHmacSha256HashCryptoDriver()
        {
            this->!HsmHmacSha256HashCryptoDriver();
        }

        !HsmHmacSha256HashCryptoDriver()
        {
        }

        virtual void CalculateHash(array<Byte>^ src, int srcOffset, int srcSize, array<Byte>^ dst, int dstOffset)
        {
            pin_ptr<unsigned char> pinSrc = &src[srcOffset];
            pin_ptr<unsigned char> pinDst = &dst[dstOffset];

            m_HsmInterface->GenerateHmacSha256(m_HsmKeyIndex, pinDst, HashSize, pinSrc, srcSize);

            pinSrc = nullptr;
            pinDst = nullptr;

            GC::KeepAlive(this);
        }

    private:
        HsmInterface^ m_HsmInterface;
        HmacSha256KeyIndex m_HsmKeyIndex;
    };

}}}
