﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/crypto/crypto_HmacSha256Generator.h>
#include <nn/crypto/crypto_HmacGenerator.h>
#include "IHashCalculator.h"

namespace Nintendo { namespace Authoring { namespace CryptoLibrary {

using namespace System;

    public ref class HmacSha256HashCryptoDriver : IHashCalculator
    {
    public:
        property int KeySize
        {
            virtual int get() { return 32; }
        }

        property int HashSize
        {
            virtual int get() { return 32; }
        }

        HmacSha256HashCryptoDriver(array<Byte>^ key)
        {
            m_Key = key;
        }

        HmacSha256HashCryptoDriver(HmacSha256KeyIndex keyIndex)
        {
            switch (keyIndex)
            {
            case HmacSha256KeyIndex::TitleKeyGenarateKey:
                m_Key = TitleKeyGenarateKey;
                break;
            default:
                throw gcnew ArgumentException("Invalid KeyIndex.");
            }
        }

        ~HmacSha256HashCryptoDriver()
        {
            this->!HmacSha256HashCryptoDriver();
        }

        !HmacSha256HashCryptoDriver()
        {
        }

        virtual void CalculateHash(array<Byte>^ src, int srcOffset, int srcSize, array<Byte>^ dst, int dstOffset)
        {
            pin_ptr<unsigned char> pinSrc = &src[srcOffset];
            pin_ptr<unsigned char> pinDst = &dst[dstOffset];
            pin_ptr<unsigned char> pinKey = &m_Key[0];

            nn::crypto::GenerateHmacSha256Mac(pinDst, HashSize, pinSrc, srcSize, pinKey, KeySize);

            pinSrc = nullptr;
            pinDst = nullptr;
            pinKey = nullptr;
        }

    private:
        array<Byte>^ m_Key;

        static array<Byte>^ TitleKeyGenarateKey =
        {
            0x27, 0x6f, 0x38, 0xbc, 0x44, 0x6a, 0xf1, 0x56, 0x1f, 0x2c, 0x5a, 0x6f, 0x74, 0x20, 0x5d, 0xc5,
            0x19, 0xb5, 0x3b, 0xbc, 0xb2, 0x9f, 0xd3, 0xaf, 0xd4, 0xb2, 0xa2, 0x04, 0x1c, 0x98, 0x75, 0x7e,
        };
    };

}}}
