﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Xml.Serialization;

namespace Nintendo.Authoring.AuthoringLibrary
{
    [XmlRoot("UnresolvedApiList", IsNullable = false)]
    public class UnresolvedApiList
    {
        [XmlElement("UnresolvedApi")]
        public List<UnresolvedApiModel> Entries { get; set; }
        static public UnresolvedApiList Create(UndefSymbolInfo[] undefSymbolInfos)
        {
            var model = new UnresolvedApiList();
            model.Entries = new List<UnresolvedApiModel>();
            foreach (var moduleInfo in undefSymbolInfos)
            {
                var entry = new UnresolvedApiModel();
                entry.ApiName = moduleInfo.ApiName;
                entry.NsoName = moduleInfo.NsoName;
                model.Entries.Add(entry);
            }
            return model;
        }
        static public UnresolvedApiList Create()
        {
            var model = new UnresolvedApiList();
            model.Entries = new List<UnresolvedApiModel>();
            return model;
        }
        public List<string> GetApiNameList()
        {
            return Entries.Select(entry => { return entry.ApiName; }).ToList();
        }
    }

    [XmlRoot("UnresolvedApi")]
    public class UnresolvedApiModel
    {
        [XmlElement("ApiName", IsNullable = false)]
        public string ApiName { get; set; }

        [XmlElement("NsoName", IsNullable = false)]
        public string NsoName { get; set; }
    }
}
