﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Xml.Serialization;
using System.Runtime.InteropServices;

namespace Nintendo.Authoring.AuthoringLibrary
{
    [StructLayout(LayoutKind.Sequential)]
    public struct FsAccessControlStruct
    {
        public UInt32 version;
        public UInt64 flagPresetsBit;
        public UInt32 contentOwnerInfoOffset;
        public UInt32 saveDataOwnerInfoOffset;
        public UInt32 saveDataOwnerInfoSize;
    }

    [XmlRoot("FsAccessControlData", IsNullable = false)]
    public class FsAccessControlData
    {
        public class SaveDataOwnerId
        {
            public string Accessibility { get; set; }
            public string Id { get; set; }

            public static string GetAccessibilityString(byte value)
            {
                switch (value)
                {
                    case 1:
                        return "Read";
                    case 2:
                        return "Write";
                    case 3:
                        return "ReadWrite";
                    default:
                        throw new ArgumentException();
                }
            }
        }

        [XmlElement("SaveDataOwnerIds")]
        public List<SaveDataOwnerIdsModel> Entries { get; set; }

        static public FsAccessControlData Create(SaveDataOwnerId[] SaveDataOwnerIdArray)
        {
            var model = new FsAccessControlData();
            model.Entries = new List<SaveDataOwnerIdsModel>();

            foreach (var saveDataOwnerId in SaveDataOwnerIdArray)
            {
                var entry = new SaveDataOwnerIdsModel();
                entry.Accessibility = saveDataOwnerId.Accessibility;
                entry.Id = saveDataOwnerId.Id;
                model.Entries.Add(entry);
            }
            return model;
        }
        static public FsAccessControlData Create()
        {
            var model = new FsAccessControlData();
            model.Entries = new List<SaveDataOwnerIdsModel>();
            return model;
        }
    }

    [XmlRoot("SaveDataOwnerIds")]
    public class SaveDataOwnerIdsModel
    {
        [XmlElement("Accessibility", IsNullable = false)]
        public string Accessibility { get; set; }

        [XmlElement("Id", IsNullable = false)]
        public string Id { get; set; }
    }

}
