﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using Nintendo.Authoring.CryptoLibrary;

namespace Nintendo.Authoring.AuthoringLibrary
{
    public static class ExternalContentKeyGenerator
    {
        public static AesKey GetNcaExternalContentKey(IHashCalculator hashCalculator, UInt64 titleId, byte keyGeneration)
        {
            Trace.Assert(hashCalculator != null, "IHashCalculator is null.");

            // リトルエンディアンなのでビックエンディアンに変換する
            Byte[] titleIdBytes = BitConverter.GetBytes(titleId).Reverse().ToArray();

            if (keyGeneration >= TicketUtility.ChangeRightsIdAndTitleKeyKeyGenerationMin)
            {
                // keyGeneration が ChangeRightsIdAndTitleKeyKeyGenerationMin 以上の場合、鍵世代を生成ソースに埋め込む
                titleIdBytes = titleIdBytes.Concat(new byte[] { keyGeneration }).ToArray();
            }

            var hash = new Byte[hashCalculator.HashSize];

            // titleId にハッシュをかけて ハッシュ値を取得する
            hashCalculator.CalculateHash(titleIdBytes, 0, titleIdBytes.Length, hash, 0);

            // 得られたハッシュ値の上位 128bit を生の titleKey とする
            var titlekey = hash.Where((name, index) => index < 16).ToArray();

            return new AesKey(titlekey);
        }
    }
}

