﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Xml.Serialization;

namespace Nintendo.Authoring.AuthoringLibrary
{
    [XmlRoot("DebugApiList", IsNullable = false)]
    public class DebugApiList
    {
        [XmlElement("DebugApi")]
        public List<DebugApiModel> Entries { get; set; }

        static public DebugApiList Create(ModuleInfo[] moduleInfos)
        {
            var model = new DebugApiList();
            model.Entries = new List<DebugApiModel>();
            foreach (var moduleInfo in moduleInfos)
            {
                var entry = new DebugApiModel();
                entry.ApiName = moduleInfo.ModuleName;
                entry.VenderName = moduleInfo.VenderName;
                entry.NsoName = moduleInfo.FileName;
                model.Entries.Add(entry);
            }
            return model;
        }
        static public DebugApiList Create()
        {
            var model = new DebugApiList();
            model.Entries = new List<DebugApiModel>();
            return model;
        }
        public List<string> GetApiNameList()
        {
            return Entries.Select(entry => { return entry.ApiName; }).ToList();
        }
    }

    [XmlRoot("DebugApi")]
    public class DebugApiModel
    {
        [XmlElement("ApiName", IsNullable = false)]
        public string ApiName { get; set; }

        [XmlElement("VenderName", IsNullable = false)]
        public string VenderName { get; set; }

        [XmlElement("NsoName", IsNullable = false)]
        public string NsoName { get; set; }
    }
}
