from Crypto.Cipher import AES
from binascii import b2a_hex, a2b_hex
from os import urandom
import util
import Crypto.Util.Counter

iv = b2a_hex(urandom(16))

def DumpEncryptedKey(targetFile, keyFile, outputFile, prefix):
    target = util.readBinaryFile(targetFile)
    key = util.readBinaryFile(keyFile)
    aes = AES.new(
        key,
        mode = AES.MODE_CTR,
        IV = iv,
        counter = Crypto.Util.Counter.new(128))
    encryptedTarget = aes.encrypt(target)
    hexArrayExpression = "\n".join(["    " + ", ".join(["0x{0:02X}".format(x) for x in encryptedTarget[i:i+16]]) + "," for i in range(len(encryptedTarget))[::16]])
    with open(outputFile, "w", encoding="utf_8_sig") as f:
        print("""/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "systemInitializer_WrapPublicKey.h"
#include "systemInitializer_CmacFile.h"

// RSA2048 Public key for {0}
const Key2048 EncryptedWrapPublicKeyModulus{0} = {{
{{
{1}
}}
}};

const uint32_t WrapPublicKeyExponent{0} = 0x01000100;
""".format(prefix, hexArrayExpression), file = f)

DumpEncryptedKey(
    "E:\\SystemInitializer\\DevPublicKey.bin",
    "E:\\SystemInitializer\\splKeyEnc.bin",
    "D:\\home\\siglo\\sdk\\Programs\\Chris\\Sources\\TargetTools\\SystemInitializerManu\\systemInitializer_WrapPublicKeyDev.cpp",
    "Dev")
    
DumpEncryptedKey(
    "E:\\SystemInitializer\\ProdPublicKey.bin",
    "E:\\SystemInitializer\\splKeyEnc.bin",
    "D:\\home\\siglo\\sdk\\Programs\\Chris\\Sources\\TargetTools\\SystemInitializerManu\\systemInitializer_WrapPublicKeyProd.cpp",
    "Prod")
    
