﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>
#include <list>
#include <nn/nn_Result.h>

class PartitionInfo
{
public:
    PartitionInfo(std::string type, std::string name, int64_t size)
    : m_Type(type), m_Name(name), m_Size(size) {}

    std::string GetType() const { return m_Type; }
    std::string GetName() const { return m_Name; }
    int64_t GetSize() const { return m_Size; }

private:
    std::string m_Type;
    std::string m_Name;
    int64_t m_Size;
};

nn::Result ListPartitions();
nn::Result ListPartitions(std::list<PartitionInfo> *pOut);
nn::Result HasPartition(bool *pOut, std::string type, std::string name);
nn::Result ListStorages(std::list<PartitionInfo> *pOut);
nn::Result ListGptHeaders(std::list<PartitionInfo> *pOut);
nn::Result ListGptPartitions(std::list<PartitionInfo> *pOut);
nn::Result ListFsPartitions(std::list<PartitionInfo> *pOut);
