﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <Partition/systemInitializer_GptHolder.h>
#include <nn/result/result_HandlingUtility.h>
#include <Utility/systemInitializer_IBlockStorage.h>
#include <nn/utilTool/utilTool_CommandLog.h>
#include <nn/utilTool/utilTool_ResultHandlingUtility.h>

GptHolder::GptHolder()
    : m_pHeader(new GptHeader()),
      m_pPartitions(new GptPartitionEntry[GPT_DEFAULT_PARTITION_ENTRIES])
{
    NN_ABORT_UNLESS_NOT_NULL(m_pHeader);
    NN_ABORT_UNLESS_NOT_NULL(m_pPartitions);

    std::memset(m_pHeader.get(), 0, sizeof(GptHeader));
    std::memset(m_pPartitions.get(), 0, SizeOfPartitions);
}

nn::Result GptHolder::Read(IBlockStorage *pStorage)
{
    NN_UTILTOOL_RESULT_DO(ReadGptFromStorage(m_pHeader.get(), pStorage));
    NN_UTILTOOL_RESULT_DO(ReadGptPartitionsFromStorage(m_pPartitions.get(), GPT_DEFAULT_PARTITION_ENTRIES, *m_pHeader, pStorage));

    NN_RESULT_SUCCESS;
}
