﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

class IFile;

struct InitialImageInfo
{
    char signature[8];
    int32_t version;
    int32_t numPartitions;
    int8_t reserved[48];

    struct PartitionInfo
    {
        char name[72];
        int64_t address;
        int64_t size;
    };

    PartitionInfo partitions[64];
};

struct InitialImageCommand
{
    int64_t command;
    int64_t args[7];
    char stringArgument[32];
    char stringArgument2[32];
};

enum InitialImageCommandType
{
    InitialImageCommandType_WritePartitionTable = 0,
    InitialImageCommandType_WriteRawImage = 1,
    InitialImageCommandType_UpdatePartitionTable = 2,
    InitialImageCommandType_WritePartitionImage = 3,
    InitialImageCommandType_WriteSparsePartitionImage = 4,
    InitialImageCommandType_WriteFsPartitionImage = 5,
    InitialImageCommandType_WriteFsSparsePartitionImage = 6,
    InitialImageCommandType_EnsureProtectProductionInfo = 7,
    InitialImageCommandType_UpdateSecureInfo = 8,
    InitialImageCommandType_WriteBatchedBootPartitions = 9,
    InitialImageCommandType_EraseEmmcWithEscapingData = 10,
    InitialImageCommandType_InitializeZero = 11,
    InitialImageCommandType_EnableUpdatingFromBootImagePackage = 12,
    InitialImageCommandType_WriteDatabase = 13
};

struct InitialImageCommandPartition
{
    static const int MAX_COMMANDS = 64;

    int32_t numCommand;
    InitialImageCommand commands[MAX_COMMANDS];
};

class InitialImage
{
public:
    InitialImage() : m_IsInitialized(false) {}

    nn::Result Initialize(IFile *pImageFile);
    nn::Result ReadInfo(InitialImageInfo *pOut);
    int GetPartitionCount();
    InitialImageInfo::PartitionInfo GetPartitionInfo(int64_t index);
    nn::Result ReadCommandPartition(InitialImageCommandPartition *pOut);
    nn::Result ReadPartition(size_t* pOut, int64_t partitionIndex, int64_t offset, void* buffer, size_t size);

private:

    bool m_IsInitialized;
    IFile *m_pImageFile;
    InitialImageInfo m_ImageInfo;
};

void PrintInitialImageInfo(const InitialImageInfo &info);
void PrintCommandPartition(const InitialImageCommandPartition &commandPartition);
const char * GetInitialImageCommandName(InitialImageCommandType);
