﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/sm/sm_Types.h>
#include <nn/os/os_Types.h>

#include "sm_ServiceManager.h"

namespace nn { namespace sm {

    class ManagerInterface
    {
    public:
        nn::Result RegisterProcess(nn::os::ProcessId id, const nn::sf::InBuffer& accessRightsLimit, const nn::sf::InBuffer& accessRights) NN_NOEXCEPT
        {
            return sm::RegisterProcess(
                id,
                accessRightsLimit.GetPointerUnsafe(),
                accessRightsLimit.GetSize(),
                accessRights.GetPointerUnsafe(),
                accessRights.GetSize() );
        }
        nn::Result UnregisterProcess(nn::os::ProcessId id) NN_NOEXCEPT
        {
            return sm::UnregisterProcess(id);
        }

    };

}}  // namespace nn::sm
