﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SdkAssert.h>
#include <nn/sf/sf_ObjectFactory.h>
#include "bsdsocket_ClientImpl.h"

namespace nn { namespace socket { namespace detail
{
    nn::sf::SharedPointer<nn::socket::sf::IClient> CreateClientByDfc(int coreStackPermissionGroupId) NN_NOEXCEPT
    {
        // allocate a service object from default heap
        return nn::sf::DefaultObjectFactory::CreateSharedEmplaced<
            nn::socket::sf::IClient, ClientImpl>(coreStackPermissionGroupId);
    }

}}} // namespace nn::socket::detail
