﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os/os_Mutex.h>
#include <nn/socket/sfdl/socket.bsd.sfdl.h>
#include <nn/util/util_IntrusiveList.h>

namespace nn { namespace socket { namespace detail
{
    const int SocketCountMax = 256;

    class ClientImpl : public nn::sf::ISharedObject
    {
    public:
        explicit ClientImpl(int gid) NN_NOEXCEPT;

        ~ClientImpl() NN_NOEXCEPT;

        Result RegisterClient(
            nn::sf::Out<int> pOutRet,
            Bit64 pid,
            nn::sf::NativeHandle memoryHandle,
            uint64_t memorySize,
            const nn::socket::sf::LibraryConfigData configData) NN_NOEXCEPT;

        Result StartMonitoring(
            Bit64 pid) NN_NOEXCEPT;

        Result Socket(
            nn::sf::Out<int> pOutResult,
            nn::sf::Out<int> pOutError,
            int domain,
            int type,
            int protocol) NN_NOEXCEPT;

        Result SocketExempt(
            nn::sf::Out<int> pOutResult,
            nn::sf::Out<int> pOutError,
            int domain,
            int type,
            int protocol) NN_NOEXCEPT;

        Result Open(
            nn::sf::Out<int> pOutResult,
            nn::sf::Out<int> pOutError,
            const nn::sf::InBuffer& devicePath,
            int flags) NN_NOEXCEPT;

        Result Select(
            nn::sf::Out<int> pOutRet,
            nn::sf::Out<int> pOutError,
            int numberOfDescriptors,
            const nn::sf::InBuffer& inReadDescriptors,
            const nn::sf::InBuffer& inWriteDescriptors,
            const nn::sf::InBuffer& inExceptDescriptors,
            const nn::sf::OutBuffer& outReadDescriptors,
            const nn::sf::OutBuffer& outWriteDescriptors,
            const nn::sf::OutBuffer& outExceptDescriptors,
            const nn::socket::sf::SelectTimeval& selTimeout) NN_NOEXCEPT;

        Result Poll(
            nn::sf::Out<int> pOutRet,
            nn::sf::Out<int> pOutError,
            const nn::sf::InBuffer&  inDescriptors,
            const nn::sf::OutBuffer& outDescriptors,
            int numberOfDescriptors,
            int timeoutMilliseconds) NN_NOEXCEPT;

        Result Sysctl(
            nn::sf::Out<int> pOutRet,
            nn::sf::Out<int> pOutError,
            const nn::sf::InBuffer& mib,
            const nn::sf::OutBuffer& outValue,
            nn::sf::Out<unsigned int> pOutValueLength,
            const nn::sf::InBuffer& inValue) NN_NOEXCEPT;

        Result Recv(
            nn::sf::Out<int> pOutRet,
            nn::sf::Out<int> pOutError,
            int sock,
            const nn::sf::OutBuffer& outBuffer,
            int flags) NN_NOEXCEPT;

        Result RecvFrom(
            nn::sf::Out<int> pOutRet,
            nn::sf::Out<int> pOutError,
            int sock,
            const nn::sf::OutBuffer& outBuffer,
            int flags,
            const nn::sf::OutBuffer& pOutAddress,
            nn::sf::Out<unsigned int> pOutAddressLength) NN_NOEXCEPT;

        Result RecvMMsg(
            nn::sf::Out<int> pOutRet,
            nn::sf::Out<int> pOutError,
            int sock,
            const nn::sf::OutBuffer& outBuffer,
            size_t numMessages,
            int flags,
            const nn::socket::sf::Timespec& timeout) NN_NOEXCEPT;

        Result Send(
            nn::sf::Out<int> pOutRet,
            nn::sf::Out<int> pOutError,
            int sock,
            const nn::sf::InBuffer& inBuffer,
            int flags) NN_NOEXCEPT;

        Result SendTo(
            nn::sf::Out<int> pOutRet,
            nn::sf::Out<int> pOutError,
            int sock,
            const nn::sf::InBuffer& inBuffer,
            int flags,
            const nn::sf::InBuffer& inAddress) NN_NOEXCEPT;

        Result SendMMsg(
            nn::sf::Out<int> pOutRet,
            nn::sf::Out<int> pOutError,
            int sock,
            const nn::sf::InArray<nn::socket::sf::MsgHdr>& inArrayMsgHdr,
            size_t vlen,
            const nn::sf::InBuffer& inBufferPackedMsgHdrData,
            int flags) NN_NOEXCEPT;

        Result Accept(
            nn::sf::Out<int> pOutRet,
            nn::sf::Out<int> pOutError,
            int sock,
            const nn::sf::OutBuffer& pOutAddress,
            nn::sf::Out<unsigned int> pOutAddressLength) NN_NOEXCEPT;

        Result Bind(
            nn::sf::Out<int> pOutRet,
            nn::sf::Out<int> pOutError,
            int sock,
            const nn::sf::InBuffer& inAddress) NN_NOEXCEPT;

        Result Connect(
            nn::sf::Out<int> pOutRet,
            nn::sf::Out<int> pOutError,
            int sock,
            const nn::sf::InBuffer& inAddress) NN_NOEXCEPT;

        Result GetPeerName(
            nn::sf::Out<int> pOutRet,
            nn::sf::Out<int> pOutError,
            int sock,
            const nn::sf::OutBuffer& pOutAddress,
            nn::sf::Out<unsigned int> pOutAddressLength) NN_NOEXCEPT;

        Result GetSockName(
            nn::sf::Out<int> pOutRet,
            nn::sf::Out<int> pOutError,
            int sock,
            const nn::sf::OutBuffer& pOutAddress,
            nn::sf::Out<unsigned int> pOutAddressLength) NN_NOEXCEPT;

        Result GetSockOpt(
            nn::sf::Out<int> pOutRet,
            nn::sf::Out<int> pOutError,
            int sock,
            int level,
            int optionName,
            const nn::sf::OutBuffer& pOutOptionValue,
            nn::sf::Out<unsigned int> pOutOptionLength) NN_NOEXCEPT;

        Result Listen(
            nn::sf::Out<int> pOutRet,
            nn::sf::Out<int> pOutError,
            int sock,
            int backlog) NN_NOEXCEPT;

        Result Ioctl(
            nn::sf::Out<int> pOutRet,
            nn::sf::Out<int> pOutError,
            int sock,
            uint32_t command,
            const nn::sf::InBuffer& dataInSlot0,
            const nn::sf::InBuffer& dataInSlot1,
            const nn::sf::InBuffer& dataInSlot2,
            const nn::sf::InBuffer& dataInSlot3,
            const nn::sf::OutBuffer& dataOutSlot0,
            const nn::sf::OutBuffer& dataOutSlot1,
            const nn::sf::OutBuffer& dataOutSlot2,
            const nn::sf::OutBuffer& dataOutSlot3,
            int embeddedSegmentCount) NN_NOEXCEPT;

        Result Fcntl(
            nn::sf::Out<int> pOutRet,
            nn::sf::Out<int> pOutError,
            int sock,
            int command,
            int iocmd) NN_NOEXCEPT;

        Result SetSockOpt(
            nn::sf::Out<int> pOutRet,
            nn::sf::Out<int> pOutError,
            int sock,
            int level,
            int optionName,
            const nn::sf::InBuffer& inOptionValue) NN_NOEXCEPT;

        Result Shutdown(
            nn::sf::Out<int> pOutRet,
            nn::sf::Out<int> pOutError,
            int sock,
            int how) NN_NOEXCEPT;

        Result ShutdownAllSockets(
            nn::sf::Out<int> pOutRet,
            nn::sf::Out<int> pOutError,
            int forced) NN_NOEXCEPT;

        Result Write(
            nn::sf::Out<int> pOutRet,
            nn::sf::Out<int> pOutError,
            int sock,
            const nn::sf::InBuffer& inBuffer) NN_NOEXCEPT;

        Result Read(
            nn::sf::Out<int> pOutRet,
            nn::sf::Out<int> pOutError,
            int sock,
            const nn::sf::OutBuffer& outBuffer) NN_NOEXCEPT;

        Result Close(
            nn::sf::Out<int> pOutRet,
            nn::sf::Out<int> pOutError,
            int sock) NN_NOEXCEPT;

        Result DuplicateSocket(
            nn::sf::Out<int> pOutRet,
            nn::sf::Out<int> pOutError,
            int sock,
            Bit64 ownerProcessId) NN_NOEXCEPT;

        Result GetResourceStatistics(
            nn::sf::Out<int> pOutRet,
            nn::sf::Out<int> pOutError,
            Bit64 pid,
            int32_t type,
            const nn::sf::OutBuffer& outBuffer,
            uint32_t options) NN_NOEXCEPT;

    private:

        void CancelAndWait() NN_NOEXCEPT;

        Bit64 m_ProcessId;
        nn::sf::SharedPointer<ClientImpl> m_pMonitorTarget;
        bool m_IsRegistered;
        int m_CoreStackPermissionGroupId;
    };

}}} // namespace nn::socket::detail
