﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#if defined(NN_BUILD_CONFIG_HARDWARE_JETSONTX2)

const size_t MallocMemoryPoolSize = (2048 * 1024);
const size_t EthMemoryPoolSize = (1024 * 1024);

#define NN_DETAIL_BSDSOCKET_ENABLE_WLAN false
#define NN_DETAIL_BSDSOCKET_ENABLE_NSD  false

#else

const size_t MallocMemoryPoolSize = (1024 * 1024);
const size_t EthMemoryPoolSize = (420 * 1024);

#define NN_DETAIL_BSDSOCKET_ENABLE_WLAN true
#define NN_DETAIL_BSDSOCKET_ENABLE_NSD  true

#endif
