﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nn;
using nn.sf;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;

namespace nn.fs
{
    [CppRefPath(@"<nn/fs/fs_File.h>")]
    [ExternalStruct(4, 4)]
    public struct ReadOption
    {
    }

    [CppRefPath(@"<nn/fs/fs_File.h>")]
    [ExternalStruct(4, 4)]
    public struct WriteOption
    {
    }

    [CppRefPath(@"<nn/fs/fs_Directory.h>")]
    [ExternalStruct(784, 8)]
    [LargeData]
    public struct DirectoryEntry
    {
    }
}

namespace nn.tma
{
    [CppRefPath(@"<nn/tma/sf/tma_IFileManager.h>")]
    [LargeData]
    public struct Path
    {
        [FixedArray(769)]
        public char_t[] str;
    }

    [CppRefPath(@"<nn/tma/sf/tma_IFileManager.h>")]
    public interface IFileManager : IServiceObject
    {
        [MethodId(0)]
        Result OpenFile             ( Out<IFileAccessor>    handle,
                                      Path                  pPath,
                                      std.uint32_t          openMode );

        [MethodId(1)]
        Result FileExists           ( Out<bool>             pExists,
                                      Path                  pPath );

        [MethodId(2)]
        Result DeleteFile           ( Path                  pPath );

        [MethodId(3)]
        Result RenameFile           ( Path                  pFromName,
                                      Path                  pToName );

        [MethodId(4)]
        Result GetIOType            ( nn.sf.Out<std.int32_t>    pType,
                                      Path                  pPath );

        [MethodId(5)]
        Result OpenDirectory        ( Out<IDirectoryAccessor>   pHandle,
                                      Path                      pathName,
                                      std.int32_t               openMode );

        [MethodId(6)]
        Result DirectoryExists      ( Out<bool>                 pOut,
                                      Path                      pathName );

        [MethodId(7)]
        Result CreateDirectory      ( Path                      pathName );

        [MethodId(8)]
        Result DeleteDirectory      ( Path                      pathName,
                                      bool                      recursively );

        [MethodId(9)]
        Result RenameDirectory      ( Path                      fromName,
                                      Path                      toName );

        [MethodId(10)]
        Result CreateFile           ( Path                      pPath,
                                      std.int64_t               size );
        [MethodId(11)]
        Result GetFileTimeStamp     ( nn.sf.Out<std.uint64_t>   pCreateTime,
                                      nn.sf.Out<std.uint64_t>   pAccessTime,
                                      nn.sf.Out<std.uint64_t>   pModifyTime,
                                      Path                      pPath );
    }

    [CppRefPath(@"<nn/tma/sf/tma_IFileManager.h>")]
    public interface IFileAccessor : IServiceObject
    {
        [MethodId(0)]
        Result ReadFile             ( nn.sf.Out<std.int64_t>    pOut,
                                      std.int64_t               offset,
                                      [NonSecureMapTransfer] nn.sf.OutBuffer pBuffer,
                                      nn.fs.ReadOption          option );

        [MethodId(1)]
        Result WriteFile            ( std.int64_t               offset,
                                      [NonSecureMapTransfer] nn.sf.InBuffer pBuffer,
                                      nn.fs.WriteOption         option );

        [MethodId(2)]
        Result GetFileSize          ( nn.sf.Out<std.int64_t>    pOut );

        [MethodId(3)]
        Result SetFileSize          ( std.int64_t               size );

        [MethodId(4)]
        Result FlushFile            ();

        [MethodId(5)]
        Result SetPriorityForFile   ( std.int32_t               priority );

        [MethodId(6)]
        Result GetPriorityForFile   ( nn.sf.Out<std.int32_t>    pOut );
    }

    [CppRefPath(@"<nn/tma/sf/tma_IFileManager.h>")]
    public interface IDirectoryAccessor : IServiceObject
    {
        [MethodId(0)]
        Result GetEntryCount        ( Out<std.int64_t>          pCount );

        [MethodId(1)]
        Result ReadDirectory        ( Out<std.int64_t>          pOut,
                                      [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<nn.fs.DirectoryEntry> pEntries);

        [MethodId(2)]
        Result SetPriorityForDirectory  ( std.int32_t           priority );

        [MethodId(3)]
        Result GetPriorityForDirectory  ( Out<std.int32_t>      pOut );
    }
}
