﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*
 * このファイルを編集しないでください。
 * このファイルは自動生成されます。
 */

#include <nn/svc/svc_DmntId.autogen.h>


//-------------------------------------------------
// Result GetDebugFutureThreadInfo(nn::svc::lp64::LastThreadContext* pContext, nn::Bit64* threadId, nn::svc::Handle debug, int64_t ns)
//
//     AArch64 s=8 r=8 p=4           Invariant s=8 r=8 p=8
// in  abi                           svc
//     Register 0  ref 32 pContext   
//     Register 1  ref  8 threadId   
//     Register 2       4 debug      Register 2       4 debug
//     Register 3       8 ns         Register 3       8 ns
//
// out abi                           svc
//     Register 0       4 return     Register 0       4 return
//                                   Register 1      32 pContext
//                                   Register 2      32 pContext
//                                   Register 3      32 pContext
//                                   Register 4      32 pContext
//                                   Register 5       8 threadId
//
// conversion
//   Scatter         pContext
//   Scatter         threadId

    .section .text._ZN2nn3svc7aarch645ilp3224GetDebugFutureThreadInfoEPNS0_4lp6417LastThreadContextEPyNS0_6HandleEx, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3224GetDebugFutureThreadInfoEPNS0_4lp6417LastThreadContextEPyNS0_6HandleEx
    .hidden  _ZN2nn3svc7aarch645ilp3224GetDebugFutureThreadInfoEPNS0_4lp6417LastThreadContextEPyNS0_6HandleEx
    .type    _ZN2nn3svc7aarch645ilp3224GetDebugFutureThreadInfoEPNS0_4lp6417LastThreadContextEPyNS0_6HandleEx, %function
_ZN2nn3svc7aarch645ilp3224GetDebugFutureThreadInfoEPNS0_4lp6417LastThreadContextEPyNS0_6HandleEx:

    stp      x0, x1, [sp, #-16]!

    svc      #NN_SVC_ID_GET_DEBUG_FUTURE_THREAD_INFO

    ldr      x6, [sp, #0]              // pContextのアドレス をスタックからレジスタへ
    str      x1, [x6, #0]              // pContext の第 1 ワードをレジスタからメモリへ
    str      x2, [x6, #8]              // pContext の第 2 ワードをレジスタからメモリへ
    str      x3, [x6, #16]             // pContext の第 3 ワードをレジスタからメモリへ
    str      x4, [x6, #24]             // pContext の第 4 ワードをレジスタからメモリへ
    ldr      x6, [sp, #8]              // threadIdのアドレス をスタックからレジスタへ
    str      x5, [x6, #0]              // threadId の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch645ilp3224GetDebugFutureThreadInfoEPNS0_4lp6417LastThreadContextEPyNS0_6HandleEx, [.-_ZN2nn3svc7aarch645ilp3224GetDebugFutureThreadInfoEPNS0_4lp6417LastThreadContextEPyNS0_6HandleEx]


//-------------------------------------------------
// Result DebugActiveProcess(nn::svc::Handle* pOut, nn::Bit64 processId)
//
//     AArch64 s=8 r=8 p=4            Invariant s=8 r=8 p=8
// in  abi                            svc
//     Register 0  ref  4 pOut        
//     Register 1       8 processId   Register 1       8 processId
//
// out abi                            svc
//     Register 0       4 return      Register 0       4 return
//                                    Register 1       4 pOut
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn3svc7aarch645ilp3218DebugActiveProcessEPNS0_6HandleEy, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3218DebugActiveProcessEPNS0_6HandleEy
    .hidden  _ZN2nn3svc7aarch645ilp3218DebugActiveProcessEPNS0_6HandleEy
    .type    _ZN2nn3svc7aarch645ilp3218DebugActiveProcessEPNS0_6HandleEy, %function
_ZN2nn3svc7aarch645ilp3218DebugActiveProcessEPNS0_6HandleEy:

    str      x0, [sp, #-16]!

    svc      #NN_SVC_ID_DEBUG_ACTIVE_PROCESS

    ldr      x2, [sp, #0]              // pOutのアドレス をスタックからレジスタへ
    str      w1, [x2, #0]              // pOut の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch645ilp3218DebugActiveProcessEPNS0_6HandleEy, [.-_ZN2nn3svc7aarch645ilp3218DebugActiveProcessEPNS0_6HandleEy]


//-------------------------------------------------
// Result BreakDebugProcess(nn::svc::Handle debug)
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0       4 debug    Register 0       4 debug
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3217BreakDebugProcessENS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3217BreakDebugProcessENS0_6HandleE
    .hidden  _ZN2nn3svc7aarch645ilp3217BreakDebugProcessENS0_6HandleE
    .type    _ZN2nn3svc7aarch645ilp3217BreakDebugProcessENS0_6HandleE, %function
_ZN2nn3svc7aarch645ilp3217BreakDebugProcessENS0_6HandleE:

    svc      #NN_SVC_ID_BREAK_DEBUG_PROCESS
    ret

    .size _ZN2nn3svc7aarch645ilp3217BreakDebugProcessENS0_6HandleE, [.-_ZN2nn3svc7aarch645ilp3217BreakDebugProcessENS0_6HandleE]


//-------------------------------------------------
// Result TerminateDebugProcess(nn::svc::Handle debug)
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0       4 debug    Register 0       4 debug
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3221TerminateDebugProcessENS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3221TerminateDebugProcessENS0_6HandleE
    .hidden  _ZN2nn3svc7aarch645ilp3221TerminateDebugProcessENS0_6HandleE
    .type    _ZN2nn3svc7aarch645ilp3221TerminateDebugProcessENS0_6HandleE, %function
_ZN2nn3svc7aarch645ilp3221TerminateDebugProcessENS0_6HandleE:

    svc      #NN_SVC_ID_TERMINATE_DEBUG_PROCESS
    ret

    .size _ZN2nn3svc7aarch645ilp3221TerminateDebugProcessENS0_6HandleE, [.-_ZN2nn3svc7aarch645ilp3221TerminateDebugProcessENS0_6HandleE]


//-------------------------------------------------
// Result GetDebugEvent(nn::svc::lp64::DebugEventInfo* pInfo, nn::svc::Handle debug)
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0  ref 64 pInfo    Register 0  ref 64 pInfo
//     Register 1       4 debug    Register 1       4 debug
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3213GetDebugEventEPNS0_4lp6414DebugEventInfoENS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3213GetDebugEventEPNS0_4lp6414DebugEventInfoENS0_6HandleE
    .hidden  _ZN2nn3svc7aarch645ilp3213GetDebugEventEPNS0_4lp6414DebugEventInfoENS0_6HandleE
    .type    _ZN2nn3svc7aarch645ilp3213GetDebugEventEPNS0_4lp6414DebugEventInfoENS0_6HandleE, %function
_ZN2nn3svc7aarch645ilp3213GetDebugEventEPNS0_4lp6414DebugEventInfoENS0_6HandleE:

    svc      #NN_SVC_ID_GET_DEBUG_EVENT
    ret

    .size _ZN2nn3svc7aarch645ilp3213GetDebugEventEPNS0_4lp6414DebugEventInfoENS0_6HandleE, [.-_ZN2nn3svc7aarch645ilp3213GetDebugEventEPNS0_4lp6414DebugEventInfoENS0_6HandleE]


//-------------------------------------------------
// Result ContinueDebugEvent(nn::svc::Handle debug, nn::Bit32 flags, const nn::Bit64 pThreadIds[], int32_t arraySize)
//
//     AArch64 s=8 r=8 p=4             Invariant s=8 r=8 p=8
// in  abi                             svc
//     Register 0       4 debug        Register 0       4 debug
//     Register 1       4 flags        Register 1       4 flags
//     Register 2  ref -- pThreadIds   Register 2  ref -- pThreadIds
//     Register 3       4 arraySize    Register 3       4 arraySize
//
// out abi                             svc
//     Register 0       4 return       Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3218ContinueDebugEventENS0_6HandleEjPKyi, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3218ContinueDebugEventENS0_6HandleEjPKyi
    .hidden  _ZN2nn3svc7aarch645ilp3218ContinueDebugEventENS0_6HandleEjPKyi
    .type    _ZN2nn3svc7aarch645ilp3218ContinueDebugEventENS0_6HandleEjPKyi, %function
_ZN2nn3svc7aarch645ilp3218ContinueDebugEventENS0_6HandleEjPKyi:

    svc      #NN_SVC_ID_CONTINUE_DEBUG_EVENT
    ret

    .size _ZN2nn3svc7aarch645ilp3218ContinueDebugEventENS0_6HandleEjPKyi, [.-_ZN2nn3svc7aarch645ilp3218ContinueDebugEventENS0_6HandleEjPKyi]


//-------------------------------------------------
// Result GetProcessList(int32_t* pNumProcesses, nn::Bit64 pProcessIds[], int32_t arraySize)
//
//     AArch64 s=8 r=8 p=4                Invariant s=8 r=8 p=8
// in  abi                                svc
//     Register 0  ref  4 pNumProcesses   
//     Register 1  ref -- pProcessIds     Register 1  ref -- pProcessIds
//     Register 2       4 arraySize       Register 2       4 arraySize
//
// out abi                                svc
//     Register 0       4 return          Register 0       4 return
//                                        Register 1       4 pNumProcesses
//
// conversion
//   Scatter         pNumProcesses

    .section .text._ZN2nn3svc7aarch645ilp3214GetProcessListEPiPyi, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3214GetProcessListEPiPyi
    .hidden  _ZN2nn3svc7aarch645ilp3214GetProcessListEPiPyi
    .type    _ZN2nn3svc7aarch645ilp3214GetProcessListEPiPyi, %function
_ZN2nn3svc7aarch645ilp3214GetProcessListEPiPyi:

    str      x0, [sp, #-16]!

    svc      #NN_SVC_ID_GET_PROCESS_LIST

    ldr      x2, [sp, #0]              // pNumProcessesのアドレス をスタックからレジスタへ
    str      w1, [x2, #0]              // pNumProcesses の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch645ilp3214GetProcessListEPiPyi, [.-_ZN2nn3svc7aarch645ilp3214GetProcessListEPiPyi]


//-------------------------------------------------
// Result GetThreadList(int32_t* pNumThreads, nn::Bit64 pThreadIds[], int32_t arraySize, nn::svc::Handle domain)
//
//     AArch64 s=8 r=8 p=4              Invariant s=8 r=8 p=8
// in  abi                              svc
//     Register 0  ref  4 pNumThreads   
//     Register 1  ref -- pThreadIds    Register 1  ref -- pThreadIds
//     Register 2       4 arraySize     Register 2       4 arraySize
//     Register 3       4 domain        Register 3       4 domain
//
// out abi                              svc
//     Register 0       4 return        Register 0       4 return
//                                      Register 1       4 pNumThreads
//
// conversion
//   Scatter         pNumThreads

    .section .text._ZN2nn3svc7aarch645ilp3213GetThreadListEPiPyiNS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3213GetThreadListEPiPyiNS0_6HandleE
    .hidden  _ZN2nn3svc7aarch645ilp3213GetThreadListEPiPyiNS0_6HandleE
    .type    _ZN2nn3svc7aarch645ilp3213GetThreadListEPiPyiNS0_6HandleE, %function
_ZN2nn3svc7aarch645ilp3213GetThreadListEPiPyiNS0_6HandleE:

    str      x0, [sp, #-16]!

    svc      #NN_SVC_ID_GET_THREAD_LIST

    ldr      x2, [sp, #0]              // pNumThreadsのアドレス をスタックからレジスタへ
    str      w1, [x2, #0]              // pNumThreads の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch645ilp3213GetThreadListEPiPyiNS0_6HandleE, [.-_ZN2nn3svc7aarch645ilp3213GetThreadListEPiPyiNS0_6HandleE]


//-------------------------------------------------
// Result GetDebugThreadContext(nn::svc::ThreadContext* pContext, nn::svc::Handle debug, nn::Bit64 threadId, nn::Bit32 controlFlags)
//
//     AArch64 s=8 r=8 p=4               Invariant s=8 r=8 p=8
// in  abi                               svc
//     Register 0  ref 332 pContext      Register 0  ref 332 pContext
//     Register 1       4 debug          Register 1       4 debug
//     Register 2       8 threadId       Register 2       8 threadId
//     Register 3       4 controlFlags   Register 3       4 controlFlags
//
// out abi                               svc
//     Register 0       4 return         Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3221GetDebugThreadContextEPNS0_13ThreadContextENS0_6HandleEyj, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3221GetDebugThreadContextEPNS0_13ThreadContextENS0_6HandleEyj
    .hidden  _ZN2nn3svc7aarch645ilp3221GetDebugThreadContextEPNS0_13ThreadContextENS0_6HandleEyj
    .type    _ZN2nn3svc7aarch645ilp3221GetDebugThreadContextEPNS0_13ThreadContextENS0_6HandleEyj, %function
_ZN2nn3svc7aarch645ilp3221GetDebugThreadContextEPNS0_13ThreadContextENS0_6HandleEyj:

    svc      #NN_SVC_ID_GET_DEBUG_THREAD_CONTEXT
    ret

    .size _ZN2nn3svc7aarch645ilp3221GetDebugThreadContextEPNS0_13ThreadContextENS0_6HandleEyj, [.-_ZN2nn3svc7aarch645ilp3221GetDebugThreadContextEPNS0_13ThreadContextENS0_6HandleEyj]


//-------------------------------------------------
// Result SetDebugThreadContext(nn::svc::Handle debug, nn::Bit64 threadId, const nn::svc::ThreadContext& context, nn::Bit32 controlFlags)
//
//     AArch64 s=8 r=8 p=4               Invariant s=8 r=8 p=8
// in  abi                               svc
//     Register 0       4 debug          Register 0       4 debug
//     Register 1       8 threadId       Register 1       8 threadId
//     Register 2  ref 332 context       Register 2  ref 332 context
//     Register 3       4 controlFlags   Register 3       4 controlFlags
//
// out abi                               svc
//     Register 0       4 return         Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3221SetDebugThreadContextENS0_6HandleEyRKNS0_13ThreadContextEj, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3221SetDebugThreadContextENS0_6HandleEyRKNS0_13ThreadContextEj
    .hidden  _ZN2nn3svc7aarch645ilp3221SetDebugThreadContextENS0_6HandleEyRKNS0_13ThreadContextEj
    .type    _ZN2nn3svc7aarch645ilp3221SetDebugThreadContextENS0_6HandleEyRKNS0_13ThreadContextEj, %function
_ZN2nn3svc7aarch645ilp3221SetDebugThreadContextENS0_6HandleEyRKNS0_13ThreadContextEj:

    svc      #NN_SVC_ID_SET_DEBUG_THREAD_CONTEXT
    ret

    .size _ZN2nn3svc7aarch645ilp3221SetDebugThreadContextENS0_6HandleEyRKNS0_13ThreadContextEj, [.-_ZN2nn3svc7aarch645ilp3221SetDebugThreadContextENS0_6HandleEyRKNS0_13ThreadContextEj]


//-------------------------------------------------
// Result QueryDebugProcessMemory(nn::svc::lp64::MemoryInfo* pBlockInfo, nn::svc::PageInfo* pPageInfo, nn::svc::Handle process, uintptr_t addr)
//
//     AArch64 s=8 r=8 p=4             Invariant s=8 r=8 p=8
// in  abi                             svc
//     Register 0  ref 40 pBlockInfo   Register 0  ref 40 pBlockInfo
//     Register 1  ref  4 pPageInfo    
//     Register 2       4 process      Register 2       4 process
//     Register 3       4 addr         Register 3       8 addr
//
// out abi                             svc
//     Register 0       4 return       Register 0       4 return
//                                     Register 1       4 pPageInfo
//
// conversion
//   Scatter         pPageInfo

    .section .text._ZN2nn3svc7aarch645ilp3223QueryDebugProcessMemoryEPNS0_4lp6410MemoryInfoEPNS0_8PageInfoENS0_6HandleEm, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3223QueryDebugProcessMemoryEPNS0_4lp6410MemoryInfoEPNS0_8PageInfoENS0_6HandleEm
    .hidden  _ZN2nn3svc7aarch645ilp3223QueryDebugProcessMemoryEPNS0_4lp6410MemoryInfoEPNS0_8PageInfoENS0_6HandleEm
    .type    _ZN2nn3svc7aarch645ilp3223QueryDebugProcessMemoryEPNS0_4lp6410MemoryInfoEPNS0_8PageInfoENS0_6HandleEm, %function
_ZN2nn3svc7aarch645ilp3223QueryDebugProcessMemoryEPNS0_4lp6410MemoryInfoEPNS0_8PageInfoENS0_6HandleEm:

    str      x1, [sp, #-16]!

    svc      #NN_SVC_ID_QUERY_DEBUG_PROCESS_MEMORY

    ldr      x2, [sp, #0]              // pPageInfoのアドレス をスタックからレジスタへ
    str      w1, [x2, #0]              // pPageInfo の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch645ilp3223QueryDebugProcessMemoryEPNS0_4lp6410MemoryInfoEPNS0_8PageInfoENS0_6HandleEm, [.-_ZN2nn3svc7aarch645ilp3223QueryDebugProcessMemoryEPNS0_4lp6410MemoryInfoEPNS0_8PageInfoENS0_6HandleEm]


//-------------------------------------------------
// Result ReadDebugProcessMemory(uintptr_t buf, nn::svc::Handle debug, uintptr_t addr, size_t size)
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0       4 buf      Register 0       8 buf
//     Register 1       4 debug    Register 1       4 debug
//     Register 2       4 addr     Register 2       8 addr
//     Register 3       4 size     Register 3       8 size
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3222ReadDebugProcessMemoryEmNS0_6HandleEmm, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3222ReadDebugProcessMemoryEmNS0_6HandleEmm
    .hidden  _ZN2nn3svc7aarch645ilp3222ReadDebugProcessMemoryEmNS0_6HandleEmm
    .type    _ZN2nn3svc7aarch645ilp3222ReadDebugProcessMemoryEmNS0_6HandleEmm, %function
_ZN2nn3svc7aarch645ilp3222ReadDebugProcessMemoryEmNS0_6HandleEmm:

    svc      #NN_SVC_ID_READ_DEBUG_PROCESS_MEMORY
    ret

    .size _ZN2nn3svc7aarch645ilp3222ReadDebugProcessMemoryEmNS0_6HandleEmm, [.-_ZN2nn3svc7aarch645ilp3222ReadDebugProcessMemoryEmNS0_6HandleEmm]


//-------------------------------------------------
// Result WriteDebugProcessMemory(nn::svc::Handle debug, uintptr_t buf, uintptr_t addr, size_t size)
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0       4 debug    Register 0       4 debug
//     Register 1       4 buf      Register 1       8 buf
//     Register 2       4 addr     Register 2       8 addr
//     Register 3       4 size     Register 3       8 size
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3223WriteDebugProcessMemoryENS0_6HandleEmmm, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3223WriteDebugProcessMemoryENS0_6HandleEmmm
    .hidden  _ZN2nn3svc7aarch645ilp3223WriteDebugProcessMemoryENS0_6HandleEmmm
    .type    _ZN2nn3svc7aarch645ilp3223WriteDebugProcessMemoryENS0_6HandleEmmm, %function
_ZN2nn3svc7aarch645ilp3223WriteDebugProcessMemoryENS0_6HandleEmmm:

    svc      #NN_SVC_ID_WRITE_DEBUG_PROCESS_MEMORY
    ret

    .size _ZN2nn3svc7aarch645ilp3223WriteDebugProcessMemoryENS0_6HandleEmmm, [.-_ZN2nn3svc7aarch645ilp3223WriteDebugProcessMemoryENS0_6HandleEmmm]


//-------------------------------------------------
// Result SetHardwareBreakPoint(nn::svc::HardwareBreakPointRegisterName regNo, nn::Bit64 control, nn::Bit64 value)
//
//     AArch64 s=8 r=8 p=4          Invariant s=8 r=8 p=8
// in  abi                          svc
//     Register 0       4 regNo     Register 0       4 regNo
//     Register 1       8 control   Register 1       8 control
//     Register 2       8 value     Register 2       8 value
//
// out abi                          svc
//     Register 0       4 return    Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3221SetHardwareBreakPointENS0_30HardwareBreakPointRegisterNameEyy, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3221SetHardwareBreakPointENS0_30HardwareBreakPointRegisterNameEyy
    .hidden  _ZN2nn3svc7aarch645ilp3221SetHardwareBreakPointENS0_30HardwareBreakPointRegisterNameEyy
    .type    _ZN2nn3svc7aarch645ilp3221SetHardwareBreakPointENS0_30HardwareBreakPointRegisterNameEyy, %function
_ZN2nn3svc7aarch645ilp3221SetHardwareBreakPointENS0_30HardwareBreakPointRegisterNameEyy:

    svc      #NN_SVC_ID_SET_HARDWARE_BREAK_POINT
    ret

    .size _ZN2nn3svc7aarch645ilp3221SetHardwareBreakPointENS0_30HardwareBreakPointRegisterNameEyy, [.-_ZN2nn3svc7aarch645ilp3221SetHardwareBreakPointENS0_30HardwareBreakPointRegisterNameEyy]


//-------------------------------------------------
// Result GetDebugThreadParam(nn::Bit64* pOut1, nn::Bit32* pOut2, nn::svc::Handle debug, nn::Bit64 threadId, nn::svc::DebugThreadParam select)
//
//     AArch64 s=8 r=8 p=4           Invariant s=8 r=8 p=8
// in  abi                           svc
//     Register 0  ref  8 pOut1      
//     Register 1  ref  4 pOut2      
//     Register 2       4 debug      Register 2       4 debug
//     Register 3       8 threadId   Register 3       8 threadId
//     Register 4       4 select     Register 4       4 select
//
// out abi                           svc
//     Register 0       4 return     Register 0       4 return
//                                   Register 1       8 pOut1
//                                   Register 2       4 pOut2
//
// conversion
//   Scatter         pOut1
//   Scatter         pOut2

    .section .text._ZN2nn3svc7aarch645ilp3219GetDebugThreadParamEPyPjNS0_6HandleEyNS0_16DebugThreadParamE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3219GetDebugThreadParamEPyPjNS0_6HandleEyNS0_16DebugThreadParamE
    .hidden  _ZN2nn3svc7aarch645ilp3219GetDebugThreadParamEPyPjNS0_6HandleEyNS0_16DebugThreadParamE
    .type    _ZN2nn3svc7aarch645ilp3219GetDebugThreadParamEPyPjNS0_6HandleEyNS0_16DebugThreadParamE, %function
_ZN2nn3svc7aarch645ilp3219GetDebugThreadParamEPyPjNS0_6HandleEyNS0_16DebugThreadParamE:

    stp      x0, x1, [sp, #-16]!

    svc      #NN_SVC_ID_GET_DEBUG_THREAD_PARAM

    ldr      x3, [sp, #0]              // pOut1のアドレス をスタックからレジスタへ
    str      x1, [x3, #0]              // pOut1 の第 1 ワードをレジスタからメモリへ
    ldr      x3, [sp, #8]              // pOut2のアドレス をスタックからレジスタへ
    str      w2, [x3, #0]              // pOut2 の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch645ilp3219GetDebugThreadParamEPyPjNS0_6HandleEyNS0_16DebugThreadParamE, [.-_ZN2nn3svc7aarch645ilp3219GetDebugThreadParamEPyPjNS0_6HandleEyNS0_16DebugThreadParamE]


    .end

