﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "serializer.h"
#include "serializer_Specializations.h"

//#define LOG_LEVEL LOG_LEVEL_MAJOR
#define LOG_MODULE_NAME "uint serializer" // NOLINT(preprocessor/const)
#include <nn/socket/resolver/private/resolver_DebugLog.h>

namespace nn { namespace socket { namespace resolver { namespace serializer {

template <>
ssize_t DNSSerializer::FromBuffer(uint16_t      & integerOut,
                                  const uint8_t * pBufferIn,
                                  size_t          bufferSize)
{
    ssize_t rc = -1;
    if ( bufferSize < sizeof(uint16_t) )
    {
        rc = -1;
        goto bail;
    }

    integerOut = InternalNtoh(*((uint16_t*)pBufferIn));
    rc = sizeof(uint16_t);

bail:
    return rc;
}

template <>
ssize_t DNSSerializer::ToBuffer(uint8_t * const pBufferOut,
                                size_t     sizeOfBuffer,
                                const uint16_t & value)
{
    ssize_t rc = -1;
    uint8_t* pBufferCurrent = pBufferOut;
    uint16_t valueSwapped = InternalHton(value);

    if ( -1 == (rc = CheckToBufferArguments(pBufferCurrent,
                                            sizeOfBuffer,
                                            sizeof(uint16_t),
                                            __LINE__)))
    {
        goto bail;
    }

    memcpy(const_cast<uint8_t*>(pBufferCurrent), &valueSwapped, sizeof(uint16_t));
    rc += sizeof(uint16_t);

bail:
    return rc;
};

template <>
ssize_t DNSSerializer::FromBuffer(uint32_t      & integerOut,
                                  const uint8_t * pBufferIn,
                                  size_t          bufferSize)
{
    ssize_t rc = -1;
    if ( bufferSize < sizeof(uint32_t) )
    {
        rc = -1;
        goto bail;
    }

    integerOut = InternalNtoh( *( (uint32_t*)pBufferIn ));
    rc = sizeof(uint32_t);

bail:
    return rc;
}

template <>
ssize_t DNSSerializer::ToBuffer(uint8_t * const pBufferOut,
                                size_t     sizeOfBuffer,
                                const uint32_t & value)
{
    ssize_t rc = -1;
    uint8_t* pBufferCurrent = pBufferOut;
    uint32_t valueSwapped = InternalHton(value);

    if ( -1 == (rc = CheckToBufferArguments(pBufferCurrent,
                                            sizeOfBuffer,
                                            sizeof(uint32_t),
                                            __LINE__)))
    {
        goto bail;
    }

    memcpy(const_cast<uint8_t*>(pBufferCurrent), &valueSwapped, sizeof(uint32_t));
    rc += sizeof(uint32_t);

bail:
    return rc;
};

}}}}// namespace nn::socket::resolver::serializer
