﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/socket/socket_TypesPrivate.h>

extern "C"
{
#include <stdint.h>
};

namespace nn { namespace socket { namespace resolver {

int CreateRandomId(int &randomIdOut) NN_NOEXCEPT;

enum OperationState
{
    OperationState_Initial = 0,

    OperationState_AcquireSlotGenericError           = 1,
    OperationState_AcquireSlotUnableToCreateHandleID = 2,
    OperationState_AcquireSlotAlreadyExists          = 3,
    OperationState_AcquireSlotSuccess                = 4,
    OperationState_AcquireSlotTableFull              = 5,

    OperationState_SetSlotRunningGenericError = 6,
    OperationState_SetSlotRunningZeroHandle   = 7,
    OperationState_SetSlotRunningPending      = 8,
    OperationState_SetSlotRunningSuccess      = 9,
    OperationState_SetSlotRunningDefault      = 10,
    OperationState_SetSlotRunningNotFound     = 11,

    OperationState_IsSlotCancelledOrExpiredGenericError = 12,
    OperationState_IsSlotCancelledOrExpiredZeroHandle   = 13,
    OperationState_IsSlotCancelledOrExpiredPending      = 14,
    OperationState_IsSlotCancelledOrExpiredAcquired     = 15,
    OperationState_IsSlotCancelledOrExpiredRunning      = 16,
    OperationState_IsSlotCancelledOrExpiredCancelled    = 17,
    OperationState_IsSlotCancelledOrExpiredExpired      = 18,
    OperationState_IsSlotCancelledOrExpiredNotFound     = 19,

    OperationState_SetSlotCancelledOrExpiredGenericError = 20,
    OperationState_SetSlotCancelledOrExpiredZeroHandle   = 21,
    OperationState_SetSlotCancelledOrExpiredPending      = 22,
    OperationState_SetSlotCancelledOrExpiredAcquired     = 23,
    OperationState_SetSlotCancelledOrExpiredRunning      = 24,
    OperationState_SetSlotCancelledOrExpiredCancelled    = 25,
    OperationState_SetSlotCancelledOrExpiredExpired      = 26,
    OperationState_SetSlotCancelledOrExpiredNotFound     = 27,

    OperationState_SetSlotPendingGenericError = 28,
    OperationState_SetSlotPendingZeroHandle   = 29,
    OperationState_SetSlotPendingPending      = 30,
    OperationState_SetSlotPendingAcquired     = 31,
    OperationState_SetSlotPendingRunning      = 32,
    OperationState_SetSlotPendingCancelled    = 33,
    OperationState_SetSlotPendingExpired      = 34,
    OperationState_SetSlotPendingNotFound     = 35,

    OperationState_CancelAllSlotsForProcessIDGenericError     = 36,
    OperationState_CancelAllSlotsForProcessIDNoSlotsCancelled = 37,
    OperationState_CancelAllSlotsForProcessIDSlotsCancelled   = 38,
};

const char* GetOperationStateString(const OperationState& stateIn);

/**
 * @brief Get the type string for the provided option.
 *
 * @param in This parameter is the ResolverOptionKey to stringify.
 */
const char* GetResolverOptionKeyString(const nn::socket::ResolverOptionKey& in);


/**
 * @brief Get the type string for the provided option.
 *
 * @param in This is the ResolverOptionType to stringify.
 */
const char* GetResolverOptionTypeString(const nn::socket::ResolverOptionType & in);

}}};
