﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/sf/sf_HipcClientProxyByName.h>        // for nn::sf::CreateHipcProxyByName
#include <nn/sf/sf_ExpHeapAllocator.h>             // for nn::sf::ExpHeapStaticAllocator
#include <nn/socket/resolver/sfdl/resolver.sfdl.h> // for IResolver
#include "resolver_ServiceName.h"                  // for ResolverServiceName
#include "resolver_CreateClient.h"


namespace nn { namespace socket { namespace resolver {

namespace
{
// Prepare an allocator that uses the expanded heap for the HIPC proxy.
struct CreateResolverByHipcTag;
typedef nn::sf::ExpHeapStaticAllocator<1024 * 16, CreateResolverByHipcTag> MyAllocator;

// Helper to initialize MyAllocator with a static constructor.
class MyAllocatorInitializer
{
public:
    MyAllocatorInitializer() NN_NOEXCEPT
    {
        MyAllocator::Initialize(nn::lmem::CreationOption_NoOption);
    }
} g_MyAllocatorInitializer;

}; //end namespace

Result CreateResolverByHipc(nn::sf::SharedPointer<IResolver> & resolverClientOut) NN_NOEXCEPT
{
    // Take the HIPC service object represented by ResolverServiceName,
    // Create a proxy client as an IResolver and return it.
    // Pass MyAllocator::Policy as the allocation policy.
    return nn::sf::CreateHipcProxyByName<IResolver,
                                         MyAllocator::Policy>(&resolverClientOut,
                                                              ResolverServiceName);
};

}}}  // nn::socket::resolver
