﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "sfsmpl_CreateCalculator.h"

#include <nn/sfsmpl/sfsmpl_ICalculator.sfdl.h> // for ICalculator
#include "sfsmpl_ServiceName.h" // for SfsmplCalculatorServiceName
#include <nn/sf/sf_HipcClientProxyByName.h> // for nn::sf::CreateHipcProxyByName
#include <nn/sf/sf_ExpHeapAllocator.h> // for nn::sf::ExpHeapStaticAllocator
#include <nn/nn_Abort.h>

namespace nn { namespace sfsmpl {

namespace {

// 拡張ヒープを使用したアロケータを、HIPC プロキシ用に準備
struct CreateCalculatorByHipcTag;
typedef nn::sf::ExpHeapStaticAllocator<1024 * 16, CreateCalculatorByHipcTag> MyAllocator;

// MyAllocator を静的コンストラクタで初期化するためのヘルパー
class MyAllocatorInitializer
{
public:

    MyAllocatorInitializer() NN_NOEXCEPT
    {
        MyAllocator::Initialize(nn::lmem::CreationOption_NoOption);
    }

} g_MyAllocatorInitializer;

}

nn::sf::SharedPointer<ICalculator> GetCalculatorByHipc() NN_NOEXCEPT
{
    // SfsmplCalculatorServiceName のサービス名で示される HIPC サービスオブジェクトを、
    // ICalculator としてプロキシクライアントを作成して返す。
    // アロケーションポリシーとして MyAllocator::Policy を渡している。
    nn::sf::SharedPointer<ICalculator> ret;
    auto result = nn::sf::CreateHipcProxyByName<ICalculator, MyAllocator::Policy>(&ret, SfsmplCalculatorServiceName);
    NN_ABORT_UNLESS(result.IsSuccess());
    return ret;
}

}}
