﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/sfsmpl/sfsmpl_ICalculator.sfdl.h>

namespace nn { namespace sfsmpl {

// ICalculator の実装用クラス
//
// ICalculator を継承はせず、各関数のシグネチャを合わせるだけでよい。
// <nn/sfsmpl/sfsmpl_ICalculator.sfdl.h> にある "Template for implementation users" をコピーできる。
class CalculatorImpl
{
public:
    nn::Result Negate(nn::sf::Out<std::int32_t> pOut, std::int32_t x) NN_NOEXCEPT;
    nn::Result Add(nn::sf::Out<std::int32_t> pOut, std::int32_t x, std::int32_t y) NN_NOEXCEPT;
    nn::Result Sub(nn::sf::Out<std::int32_t> pOut, std::int32_t x, std::int32_t y) NN_NOEXCEPT;
};

}}
