﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "sfsmpl_CalculatorImpl.h"

#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace sfsmpl {

nn::Result CalculatorImpl::Negate(nn::sf::Out<std::int32_t> pOut, std::int32_t x) NN_NOEXCEPT
{
    pOut.Set(-x);
    NN_RESULT_SUCCESS;
}

nn::Result CalculatorImpl::Add(nn::sf::Out<std::int32_t> pOut, std::int32_t x, std::int32_t y) NN_NOEXCEPT
{
    pOut.Set(x + y);
    NN_RESULT_SUCCESS;
}

nn::Result CalculatorImpl::Sub(nn::sf::Out<std::int32_t> pOut, std::int32_t x, std::int32_t y) NN_NOEXCEPT
{
    pOut.Set(x - y);
    NN_RESULT_SUCCESS;
}

}}
