﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/sf/impl/detail/sf_ServiceObjectImpl.h>

#include <nn/nn_Abort.h>
#include <limits>

namespace nn { namespace sf { namespace impl { namespace detail {

void ServiceObjectImplBase2::AddReferenceImpl() NN_NOEXCEPT
{
    auto previous = m_RefCount.fetch_add(1);
    NN_ABORT_UNLESS(previous < std::numeric_limits<InnerInt>::max(), "[SF-Internal]");
}

bool ServiceObjectImplBase2::ReleaseImpl() NN_NOEXCEPT
{
    auto previous = m_RefCount.fetch_sub(1);
    NN_ABORT_UNLESS(previous != 0, "[SF-BASE-InvalidRelease]");
    return previous == 1;
}

}}}}
