﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/sf/hipc/sf_HipcServiceResolutionApi.h>

#include <nn/sm/sm_UserApi.h>
#include <nn/sm/sm_Types.h>
#include <nn/nn_Abort.h>
#include <nn/result/result_HandlingUtility.h>

#include <nn/svc/svc_Result.h> // nn::svc::ResultMaxSessions

namespace nn { namespace sf { namespace hipc {

static_assert(sizeof(nn::sm::ServiceName) >= HipcServiceNameLengthMax, "");

void InitializeHipcServiceResolution() NN_NOEXCEPT
{
    auto result = nn::sm::Initialize();
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
}

void FinalizeHipcServiceResolution() NN_NOEXCEPT
{
    auto result = nn::sm::Finalize();
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
}

Result RegisterHipcService(HipcServerPortHandle* pOut, int32_t maxSessions, const char* name) NN_NOEXCEPT
{
    return nn::sm::RegisterService(pOut, name, maxSessions, false);
}

void UnregisterHipcService(const char* name) NN_NOEXCEPT
{
    auto result = nn::sm::UnregisterService(name);
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
}

bool IsHipcServiceRegistered(const char* name) NN_NOEXCEPT
{
    NN_UNUSED(name);
    NN_ABORT("[SF-Internal]");
    return true;
}

Result ConnectToHipcService(HipcClientSessionHandle* pOut, const char* name) NN_NOEXCEPT
{
    return nn::sm::GetServiceHandle(pOut, name);
}

Result TryConnectToHipcService(bool* pValid, HipcClientSessionHandle* pOut, const char* name) NN_NOEXCEPT
{
    NN_UNUSED(name);
    NN_ABORT("[SF-Internal]");
    *pValid = true;
    return ConnectToHipcService(pOut, name);
}

}}}
