﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <utility>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os/os_MultipleWaitTypes.h>

#include "sf_HipcEmulatedObjectBase.h"
#include "sf_HipcEmulatedSessionRequest.h"


namespace nn { namespace sf { namespace hipc {

class HipcEmulatedSessionRequest;

class HipcEmulatedClientSession
    : public HipcEmulatedObjectBase
{
protected:
    ~HipcEmulatedClientSession() NN_NOEXCEPT {}

public:
    virtual HipcEmulatedSessionRequest* CreateRequest(void* clientMessageBuffer, size_t clientMessageBufferSize) NN_NOEXCEPT = 0;

    static void AttachReplyEvent(HipcEmulatedSessionRequest* request, nn::os::MultiWaitHolderType* pHolder) NN_NOEXCEPT
    {
        request->AttachReplyEvent(pHolder);
    }

    static bool WaitRequest(HipcEmulatedSessionRequest* request) NN_NOEXCEPT
    {
        return request->WaitRequest();
    }

    static void CloseRequest(HipcEmulatedSessionRequest* request) NN_NOEXCEPT
    {
        request->CloseRequest();
    }
};


class HipcEmulatedServerSession
    : public HipcEmulatedObjectBase
{
protected:
    ~HipcEmulatedServerSession() NN_NOEXCEPT {}

public:
    virtual void AttachReceiveEvent(nn::os::MultiWaitHolderType* pHolder) NN_NOEXCEPT = 0;
    virtual Result ReceiveRequest(bool* pClosed, void* messageBuffer, size_t messageBufferSize) NN_NOEXCEPT = 0;
    virtual void Reply(void* messageBuffer, size_t messageBufferSize) NN_NOEXCEPT = 0;
};

}}}
