﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>

#include <utility>
#include <nn/sf/cmif/client/sf_CmifDomainClientMessage.h>
#include <nn/sf/hipc/client/sf_HipcClientSessionManagedProxyKind.h>
#include <nn/sf/hipc/detail/sf_IHipcManager.sfdl.h>
#include <nn/sf/cmif/client/sf_CmifProxyFactory.h>
#include <nn/sf/sf_AllocationPolicies.h>

namespace nn { namespace sf { namespace hipc { namespace client {

namespace {

struct HipcManagerProxyKind
{
    typedef HipcClientSessionHandle ObjectInfo;
    typedef client::Hipc2ClientProxyBaseObject ProxyBaseObject;
    typedef client::Hipc2ClientMessage<detail::MessageType_Invoke2ManagerMethod, false> CmifClientMessage;
};

template <typename T>
struct UnmanagedAllocator
{
    void* Allocate(size_t) NN_NOEXCEPT
    {
        return nullptr;
    }
    void Deallocate(void*, size_t) NN_NOEXCEPT
    {
    }
};

typedef cmif::client::UnmanagedCmifProxy<
    hipc::detail::IHipcManager,
    HipcManagerProxyKind,
    StatelessTypedAllocationPolicy<UnmanagedAllocator>
> UnmanagedHipcManagerProxy;

class HipcManagerAccessor
    : public UnmanagedHipcManagerProxy
{
public:

    explicit HipcManagerAccessor(HipcClientSessionHandle handle) NN_NOEXCEPT
        : UnmanagedHipcManagerProxy(handle)
    {
    }

    ~HipcManagerAccessor() NN_NOEXCEPT
    {
        GetProxyBaseObject()->Detach();
    }

};

}

Result QueryPointerBufferSize(uint16_t* pOut, HipcClientSessionHandle handle) NN_NOEXCEPT
{
    return HipcManagerAccessor(handle).QueryPointerBufferSize(pOut);
}

Result ConvertSessionToDomain(cmif::CmifDomainObjectId* pOut, HipcClientSessionHandle handle) NN_NOEXCEPT
{
    return HipcManagerAccessor(handle).ConvertCurrentObjectToDomain(pOut);
}

Result DuplicateSession(HipcClientSessionHandle* pOut, HipcClientSessionHandle clientHandle) NN_NOEXCEPT
{
    nn::sf::NativeHandle handle;
    NN_RESULT_DO(HipcManagerAccessor(clientHandle).CloneCurrentObject(&handle));
    NN_ABORT_UNLESS(handle.IsManaged(), "[SF-Internal]");
    static_assert(sizeof(*pOut) == sizeof(handle.GetOsHandle()), "");
    auto osHandle = handle.GetOsHandle();
    std::memcpy(pOut, &osHandle, sizeof(*pOut));
    handle.Detach();
    NN_RESULT_SUCCESS;
}

Result DuplicateSessionEx(HipcClientSessionHandle* pOut, HipcClientSessionHandle clientHandle, uint32_t tag) NN_NOEXCEPT
{
    nn::sf::NativeHandle handle;
    NN_RESULT_DO(HipcManagerAccessor(clientHandle).CloneCurrentObjectEx(&handle, tag));
    NN_ABORT_UNLESS(handle.IsManaged(), "[SF-Internal]");
    static_assert(sizeof(*pOut) == sizeof(handle.GetOsHandle()), "");
    auto osHandle = handle.GetOsHandle();
    std::memcpy(pOut, &osHandle, sizeof(*pOut));
    handle.Detach();
    NN_RESULT_SUCCESS;
}

}}}}
