﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nne/pinmux/pinmux.h>

namespace nne {
namespace pinmux {
namespace tegra {
namespace tx1 {

static struct DrivePadConfig initDrivePadConfigList[] =
{
    {
        DrivePadIndex_AudMclk,
        DrivePad::MakeDriveUpStrength(0x10) |
        DrivePad::MakeDriveDownStrength(0x10),
        DrivePadMask_DriveStrengthOnly,
    },
    {
        DrivePadIndex_Cam1Mclk,
        DrivePad::MakeDriveUpStrength(0x10) |
        DrivePad::MakeDriveDownStrength(0x10),
        DrivePadMask_DriveStrengthOnly,
    },
    {
        DrivePadIndex_Cam2Mclk,
        DrivePad::MakeDriveUpStrength(0x10) |
        DrivePad::MakeDriveDownStrength(0x10),
        DrivePadMask_DriveStrengthOnly,
    },
    {
        DrivePadIndex_CamAfEn,
        DrivePad::MakeDriveUpStrength(0x10) |
        DrivePad::MakeDriveDownStrength(0x10),
        DrivePadMask_DriveStrengthOnly,
    },
    {
        DrivePadIndex_CamFlashEn,
        DrivePad::MakeDriveUpStrength(0x10) |
        DrivePad::MakeDriveDownStrength(0x10),
        DrivePadMask_DriveStrengthOnly,
    },
    {
        DrivePadIndex_CamI2cScl,
        DrivePad::MakeDriveDownStrength(0x1f),
        DrivePadMask_DriveStrengthOnly,
    },
    {
        DrivePadIndex_CamI2cSda,
        DrivePad::MakeDriveDownStrength(0x1f),
        DrivePadMask_DriveStrengthOnly,
    },
    {
        DrivePadIndex_Dap4Din,
        DrivePad::MakeDriveUpStrength(0x10) |
        DrivePad::MakeDriveDownStrength(0x10),
        DrivePadMask_DriveStrengthOnly,
    },
    {
        DrivePadIndex_Dap4Dout,
        DrivePad::MakeDriveUpStrength(0x10) |
        DrivePad::MakeDriveDownStrength(0x10),
        DrivePadMask_DriveStrengthOnly,
    },
    {
        DrivePadIndex_Dap4Fs,
        DrivePad::MakeDriveUpStrength(0x10) |
        DrivePad::MakeDriveDownStrength(0x10),
        DrivePadMask_DriveStrengthOnly,
    },
    {
        DrivePadIndex_Dap4Sclk,
        DrivePad::MakeDriveUpStrength(0x10) |
        DrivePad::MakeDriveDownStrength(0x10),
        DrivePadMask_DriveStrengthOnly,
    },
    {
        DrivePadIndex_Dmic1Clk,
        DrivePad::MakeDriveUpStrength(0x10) |
        DrivePad::MakeDriveDownStrength(0x10),
        DrivePadMask_DriveStrengthOnly,
    },
    {
        DrivePadIndex_Dmic1Dat,
        DrivePad::MakeDriveUpStrength(0x10) |
        DrivePad::MakeDriveDownStrength(0x10),
        DrivePadMask_DriveStrengthOnly,
    },
    {
        DrivePadIndex_Dmic2Clk,
        DrivePad::MakeDriveUpStrength(0x10) |
        DrivePad::MakeDriveDownStrength(0x10),
        DrivePadMask_DriveStrengthOnly,
    },
    {
        DrivePadIndex_Dmic2Dat,
        DrivePad::MakeDriveUpStrength(0x10) |
        DrivePad::MakeDriveDownStrength(0x10),
        DrivePadMask_DriveStrengthOnly,
    },
    {
        DrivePadIndex_Dmic3Clk,
        DrivePad::MakeDriveUpStrength(0x1f) |
        DrivePad::MakeDriveDownStrength(0x1f),
        DrivePadMask_DriveStrengthOnly,
    },
    {
        DrivePadIndex_Dmic3Dat,
        DrivePad::MakeDriveUpStrength(0x1f) |
        DrivePad::MakeDriveDownStrength(0x1f),
        DrivePadMask_DriveStrengthOnly,
    },
    {
        DrivePadIndex_DvfsClk,
        DrivePad::MakeDriveUpStrength(0x1f) |
        DrivePad::MakeDriveDownStrength(0x1f),
        DrivePadMask_DriveStrengthOnly,
    },
    {
        DrivePadIndex_DvfsPwm,
        DrivePad::MakeDriveUpStrength(0x14) |
        DrivePad::MakeDriveDownStrength(0x04),
        DrivePadMask_DriveStrengthOnly,
    },
    {
        DrivePadIndex_Gen1I2cScl,
        DrivePad::MakeDriveDownStrength(0x1f),
        DrivePadMask_DriveStrengthOnly,
    },
    {
        DrivePadIndex_Gen1I2cSda,
        DrivePad::MakeDriveDownStrength(0x1f),
        DrivePadMask_DriveStrengthOnly,
    },
    {
        DrivePadIndex_Gen2I2cScl,
        DrivePad::MakeDriveDownStrength(0x1f),
        DrivePadMask_DriveStrengthOnly,
    },
    {
        DrivePadIndex_Gen2I2cSda,
        DrivePad::MakeDriveDownStrength(0x1f),
        DrivePadMask_DriveStrengthOnly,
    },
    {
        DrivePadIndex_Gen3I2cScl,
        DrivePad::MakeDriveDownStrength(0x07),
        DrivePadMask_DriveStrengthOnly,
    },
    {
        DrivePadIndex_Gen3I2cSda,
        DrivePad::MakeDriveDownStrength(0x07),
        DrivePadMask_DriveStrengthOnly,
    },
    {
        DrivePadIndex_GpioPz0,
        DrivePad::MakeDriveUpStrength(0x10) |
        DrivePad::MakeDriveDownStrength(0x10),
        DrivePadMask_DriveStrengthOnly,
    },
    {
        DrivePadIndex_GpioPz1,
        DrivePad::MakeDriveUpStrength(0x10) |
        DrivePad::MakeDriveDownStrength(0x10),
        DrivePadMask_DriveStrengthOnly,
    },
    {
        DrivePadIndex_GpioX1Aud,
        DrivePad::MakeDriveUpStrength(0x14) |
        DrivePad::MakeDriveDownStrength(0x04),
        DrivePadMask_DriveStrengthOnly,
    },
    {
        DrivePadIndex_GpioX3Aud,
        DrivePad::MakeDriveUpStrength(0x14) |
        DrivePad::MakeDriveDownStrength(0x04),
        DrivePadMask_DriveStrengthOnly,
    },
    {
        DrivePadIndex_PwrI2cScl,
        DrivePad::MakeDriveDownStrength(0x1f),
        DrivePadMask_DriveStrengthOnly,
    },
    {
        DrivePadIndex_PwrI2cSda,
        DrivePad::MakeDriveDownStrength(0x1f),
        DrivePadMask_DriveStrengthOnly,
    },
    {
        DrivePadIndex_TouchClk,
        DrivePad::MakeDriveUpStrength(0x14) |
        DrivePad::MakeDriveDownStrength(0x14),
        DrivePadMask_DriveStrengthOnly,
    },
    {
        DrivePadIndex_Uart3Cts,
        DrivePad::MakeDriveUpStrength(0x14) |
        DrivePad::MakeDriveDownStrength(0x04),
        DrivePadMask_DriveStrengthOnly,
    },
    {
        DrivePadIndex_Uart3Rts,
        DrivePad::MakeDriveUpStrength(0x14) |
        DrivePad::MakeDriveDownStrength(0x04),
        DrivePadMask_DriveStrengthOnly,
    },
    {
        DrivePadIndex_Uart3Rx,
        DrivePad::MakeDriveUpStrength(0x14) |
        DrivePad::MakeDriveDownStrength(0x04),
        DrivePadMask_DriveStrengthOnly,
    },
    {
        DrivePadIndex_Uart3Tx,
        DrivePad::MakeDriveUpStrength(0x14) |
        DrivePad::MakeDriveDownStrength(0x04),
        DrivePadMask_DriveStrengthOnly,
    },
    {
        DrivePadIndex_Spi1Cs0,
        DrivePad::MakeDriveUpSlew(0x50),
        DrivePadMask_DriveSlewOnly,
    },
    {
        DrivePadIndex_Spi1Cs1,
        DrivePad::MakeDriveUpSlew(0x50),
        DrivePadMask_DriveSlewOnly,
    },
    {
        DrivePadIndex_Spi1Miso,
        DrivePad::MakeDriveUpSlew(0x50),
        DrivePadMask_DriveSlewOnly,
    },
    {
        DrivePadIndex_Spi1Mosi,
        DrivePad::MakeDriveUpSlew(0x50),
        DrivePadMask_DriveSlewOnly,
    },
    {
        DrivePadIndex_Spi1Sck,
        DrivePad::MakeDriveUpSlew(0x50),
        DrivePadMask_DriveSlewOnly,
    },
    {
        DrivePadIndex_Spi2Cs0,
        DrivePad::MakeDriveUpSlew(0xd0),
        DrivePadMask_DriveSlewOnly,
    },
    {
        DrivePadIndex_Spi2Cs1,
        DrivePad::MakeDriveUpSlew(0xd0),
        DrivePadMask_DriveSlewOnly,
    },
    {
        DrivePadIndex_Spi2Miso,
        DrivePad::MakeDriveUpSlew(0xd0),
        DrivePadMask_DriveSlewOnly,
    },
    {
        DrivePadIndex_Spi2Mosi,
        DrivePad::MakeDriveUpSlew(0xd0),
        DrivePadMask_DriveSlewOnly,
    },
    {
        DrivePadIndex_Spi2Sck,
        DrivePad::MakeDriveUpSlew(0xd0),
        DrivePadMask_DriveSlewOnly,
    },
    {
        // SDMMC3 のピンを NX では GPIO として使うが、
        // DrivePad の設定は個別ではなく、一括しかできないので注意
        DrivePadIndex_Sdmmc3Pad,
        DrivePad::MakeDriveDownStrength(0x12) |
        DrivePad::MakeDriveUpStrength(0x12) |
        DrivePad::MakeDriveDownSlew(0x01) |
        DrivePad::MakeDriveUpSlew(0x01),
        DrivePadMask_DriveStrengthAndSlew,
    },
};


} // tk2
} // tegra
} // pinmux
} // nne
