﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nne {
namespace pinmux {
namespace tegra {
namespace tk2 {


static struct PinmuxPadConfig initConfigListForIcosa[] =
{
    /*
     * SFIO pinmux
     */
    {
        PinmuxPadIndex_AudMclk,
        AudMclk::Pm_Aud |
            PinmuxOpt_Output,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir
    },
    {
        PinmuxPadIndex_Dap1Din,
        Dap1Din::Pm_I2s1 |
            PinmuxOpt_Input |
            PinmuxOpt_PullDown,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_Dap1Dout,
        Dap1Dout::Pm_I2s1 |
            PinmuxOpt_Output,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir
    },
    {
        PinmuxPadIndex_Dap1Fs,
        Dap1Fs::Pm_I2s1 |
            PinmuxOpt_Output,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir
    },
    {
        PinmuxPadIndex_Dap1Sclk,
        Dap1Sclk::Pm_I2s1 |
            PinmuxOpt_Output,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir
    },
    {
        PinmuxPadIndex_Gen3I2cScl,
        Gen3I2cScl::Pm_I2c3 |
            PinmuxOpt_Bidirection |
            PinmuxOpt_NoPupd |
            PinmuxOpt_NormalVoltage,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd |
            PinmuxOptBitMask_IoHv
    },
    {
        PinmuxPadIndex_Gen3I2cSda,
        Gen3I2cSda::Pm_I2c3 |
            PinmuxOpt_Bidirection |
            PinmuxOpt_NoPupd |
            PinmuxOpt_NormalVoltage,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd |
            PinmuxOptBitMask_IoHv
    },
    {
        PinmuxPadIndex_PexL0ClkreqN,
        PexL0ClkreqN::Pm_Pe0 |
            PinmuxOpt_Input |
            PinmuxOpt_NoPupd |
            PinmuxOpt_NormalVoltage,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd |
            PinmuxOptBitMask_IoHv
    },
    {
        PinmuxPadIndex_PexL0RstN,
        PexL0RstN::Pm_Pe0 |
            PinmuxOpt_Output |
            PinmuxOpt_NormalVoltage,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_IoHv
    },
    {
        PinmuxPadIndex_PexL1ClkreqN,
        PexL1ClkreqN::Pm_Pe1 |
            PinmuxOpt_Input |
            PinmuxOpt_NoPupd |
            PinmuxOpt_NormalVoltage,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd |
            PinmuxOptBitMask_IoHv
    },
    {
        PinmuxPadIndex_PexL1RstN,
        PexL1RstN::Pm_Pe1 |
            PinmuxOpt_Output |
            PinmuxOpt_NormalVoltage,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_IoHv
    },
    {
        PinmuxPadIndex_PexWakeN,
        PexWakeN::Pm_Pe |
            PinmuxOpt_Input |
            PinmuxOpt_NoPupd |
            PinmuxOpt_NormalVoltage,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd |
            PinmuxOptBitMask_IoHv
    },
    {
        PinmuxPadIndex_Sdmmc1Clk,
        Sdmmc1Clk::Pm_Sdmmc1 |
            PinmuxOpt_Bidirection |
            PinmuxOpt_PullDown,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_Sdmmc1Cmd,
        Sdmmc1Cmd::Pm_Sdmmc1 |
            PinmuxOpt_Bidirection |
            PinmuxOpt_PullUp,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_Sdmmc1Dat0,
        Sdmmc1Dat0::Pm_Sdmmc1 |
            PinmuxOpt_Bidirection |
            PinmuxOpt_PullUp,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_Sdmmc1Dat1,
        Sdmmc1Dat1::Pm_Sdmmc1 |
            PinmuxOpt_Bidirection |
            PinmuxOpt_PullUp,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_Sdmmc1Dat2,
        Sdmmc1Dat2::Pm_Sdmmc1 |
            PinmuxOpt_Bidirection |
            PinmuxOpt_PullUp,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_Sdmmc1Dat3,
        Sdmmc1Dat3::Pm_Sdmmc1 |
            PinmuxOpt_Bidirection |
            PinmuxOpt_PullUp,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_Shutdown,
        PinmuxOpt_Output |
            PinmuxOpt_NoPupd,
        PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_LcdBlPwm,
        LcdBlPwm::Pm_Pwm0 |
            PinmuxOpt_Output,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir
    },
    {
        PinmuxPadIndex_LcdGpio2,
        LcdGpio2::Pm_Pwm1 |
            PinmuxOpt_Output |
            PinmuxOpt_NoPupd,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_PwrI2cScl,
        PwrI2cScl::Pm_I2cpmu |
            PinmuxOpt_Bidirection |
            PinmuxOpt_NoPupd |
            PinmuxOpt_NormalVoltage,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd |
            PinmuxOptBitMask_IoHv
    },
    {
        PinmuxPadIndex_PwrI2cSda,
        PwrI2cSda::Pm_I2cpmu |
            PinmuxOpt_Bidirection |
            PinmuxOpt_NoPupd |
            PinmuxOpt_NormalVoltage,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd |
            PinmuxOptBitMask_IoHv
    },
    {
        PinmuxPadIndex_Clk32kIn,
        PinmuxOpt_Input |
            PinmuxOpt_NoPupd,
        PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_Clk32kOut,
        Clk32kOut::Pm_Soc |
            PinmuxOpt_Input |
            PinmuxOpt_NoPupd,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_GpioPz5,
        GpioPz5::Pm_Soc |
            PinmuxOpt_Input |
            PinmuxOpt_PullUp,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_CorePwrReq,
        PinmuxOpt_Output |
            PinmuxOpt_NoPupd,
        PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_CpuPwrReq,
        PinmuxOpt_Output,
        PinmuxOptBitMask_Dir
    },
    {
        PinmuxPadIndex_PwrIntN,
        PinmuxOpt_Input |
            PinmuxOpt_PullUp,
        PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_Gen1I2cScl,
        Gen1I2cScl::Pm_I2c1 |
            PinmuxOpt_Bidirection |
            PinmuxOpt_NoPupd |
            PinmuxOpt_NormalVoltage,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd |
            PinmuxOptBitMask_IoHv
    },
    {
        PinmuxPadIndex_Gen1I2cSda,
        Gen1I2cSda::Pm_I2c1 |
            PinmuxOpt_Bidirection |
            PinmuxOpt_NoPupd |
            PinmuxOpt_NormalVoltage,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd |
            PinmuxOptBitMask_IoHv
    },
    {
        PinmuxPadIndex_Gen2I2cScl,
        Gen2I2cScl::Pm_I2c2 |
            PinmuxOpt_Bidirection |
            PinmuxOpt_NoPupd |
            PinmuxOpt_NormalVoltage,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd |
            PinmuxOptBitMask_IoHv
    },
    {
        PinmuxPadIndex_Gen2I2cSda,
        Gen2I2cSda::Pm_I2c2 |
            PinmuxOpt_Bidirection |
            PinmuxOpt_NoPupd |
            PinmuxOpt_NormalVoltage,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd |
            PinmuxOptBitMask_IoHv
    },
    {
        PinmuxPadIndex_Uart2Rx,
        Uart2Rx::Pm_Uartb |
            PinmuxOpt_Input |
            PinmuxOpt_NoPupd,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_Uart2Rts,
        Uart2Rts::Pm_Uartb |
            PinmuxOpt_Output,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir
    },
    {
        PinmuxPadIndex_Uart2Cts,
        Uart2Cts::Pm_Uartb |
            PinmuxOpt_Input |
            PinmuxOpt_NoPupd,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_Uart1Tx,
        Uart1Tx::Pm_Uarta |
            PinmuxOpt_Output,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir
    },
    {
        PinmuxPadIndex_Uart1Rx,
        Uart1Rx::Pm_Uarta |
            PinmuxOpt_Input |
            PinmuxOpt_PullUp,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_Uart1Rts,
        Uart1Rts::Pm_Uarta |
            PinmuxOpt_Output,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir
    },
    {
        PinmuxPadIndex_Uart1Cts,
        Uart1Cts::Pm_Uarta |
            PinmuxOpt_Input |
            PinmuxOpt_PullDown,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_JtagRtck,
        JtagRtck::Pm_Jtag |
            PinmuxOpt_Output,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir
    },
    {
        PinmuxPadIndex_GpioPl1,
        GpioPl1::Pm_Soc |
            PinmuxOpt_Input |
            PinmuxOpt_PullUp,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_Spi4Mosi,
        Spi4Mosi::Pm_Spi4 |
            PinmuxOpt_Output,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir
    },
    {
        PinmuxPadIndex_Spi4Miso,
        Spi4Miso::Pm_Spi4 |
            PinmuxOpt_Input |
            PinmuxOpt_PullUp,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_Spi4Sck,
        Spi4Sck::Pm_Spi4 |
            PinmuxOpt_Output,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir
    },
    {
        PinmuxPadIndex_Spi4Cs0,
        Spi4Cs0::Pm_Spi4 |
            PinmuxOpt_Output,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir
    },
    {
        PinmuxPadIndex_Uart3Rx,
        Uart3Rx::Pm_Uartc |
            PinmuxOpt_Input |
            PinmuxOpt_NoPupd,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_Uart3Rts,
        Uart3Rts::Pm_Uartc |
            PinmuxOpt_Output,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir
    },
    {
        PinmuxPadIndex_Uart3Cts,
        Uart3Cts::Pm_Uartc |
            PinmuxOpt_Input |
            PinmuxOpt_NoPupd,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_Uart4Tx,
        Uart4Tx::Pm_Uartd |
            PinmuxOpt_Output,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir
    },
    {
        PinmuxPadIndex_Uart4Rx,
        Uart4Rx::Pm_Uartd |
            PinmuxOpt_Input |
            PinmuxOpt_PullDown,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_Uart4Rts,
        Uart4Rts::Pm_Uartd |
            PinmuxOpt_Output,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir
    },
    {
        PinmuxPadIndex_Uart4Cts,
        Uart4Cts::Pm_Uartd |
            PinmuxOpt_Input |
            PinmuxOpt_PullDown,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_QspiIo0,
        QspiIo0::Pm_Qspi |
            PinmuxOpt_Output,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir
    },
    {
        PinmuxPadIndex_QspiIo1,
        QspiIo1::Pm_Qspi |
            PinmuxOpt_Input |
            PinmuxOpt_PullDown,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_QspiSck,
        QspiSck::Pm_Qspi |
            PinmuxOpt_Output,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir
    },
    {
        PinmuxPadIndex_QspiCsN,
        QspiCsN::Pm_Qspi |
            PinmuxOpt_Output,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir
    },
    {
        PinmuxPadIndex_Dap2Din,
        Dap2Din::Pm_I2s2 |
            PinmuxOpt_Input |
            PinmuxOpt_PullDown,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_Dap2Dout,
        Dap2Dout::Pm_I2s2 |
            PinmuxOpt_Output,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir
    },
    {
        PinmuxPadIndex_Dap2Fs,
        Dap2Fs::Pm_I2s2 |
            PinmuxOpt_Output,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir
    },
    {
        PinmuxPadIndex_Dap2Sclk,
        Dap2Sclk::Pm_I2s2 |
            PinmuxOpt_Output,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir
    },
    {
        PinmuxPadIndex_HdmiIntDpHpd,
        HdmiIntDpHpd::Pm_Dp |
            PinmuxOpt_Input |
            PinmuxOpt_NoPupd |
            PinmuxOpt_NormalVoltage,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd |
            PinmuxOptBitMask_IoHv
    },

    /*
     * GPIO pinmux
     */
    {
        PinmuxPadIndex_DvfsClk,
        PinmuxOpt_Gpio |
            PinmuxOpt_Input |
            PinmuxOpt_PullUp,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_GpioX1Aud,
        PinmuxOpt_Gpio |
            PinmuxOpt_Output,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir
    },
    {
        PinmuxPadIndex_GpioX3Aud,
        PinmuxOpt_Gpio |
            PinmuxOpt_Input |
            PinmuxOpt_PullDown,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_Dmic3Clk,
        PinmuxOpt_Gpio |
            PinmuxOpt_Output,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir
    },
    {
        PinmuxPadIndex_Dmic3Dat,
        PinmuxOpt_Gpio |
            PinmuxOpt_Output,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir
    },
    {
        PinmuxPadIndex_GpioPe6,
        PinmuxOpt_Gpio |
            PinmuxOpt_Input |
            PinmuxOpt_NoPupd,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_CamI2cSda,
        PinmuxOpt_Gpio |
            PinmuxOpt_Input |
            PinmuxOpt_PullUp |
            PinmuxOpt_NormalVoltage,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd |
            PinmuxOptBitMask_IoHv
    },
    {
        PinmuxPadIndex_Cam1Mclk,
        PinmuxOpt_Gpio |
            PinmuxOpt_Input |
            PinmuxOpt_PullDown,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_Cam2Mclk,
        PinmuxOpt_Gpio |
            PinmuxOpt_Input |
            PinmuxOpt_NoPupd,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_CamFlashEn,
        PinmuxOpt_Gpio |
            PinmuxOpt_Output,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir
    },
    {
        PinmuxPadIndex_Cam1Pwdn,
        PinmuxOpt_Gpio |
            PinmuxOpt_Input |
            PinmuxOpt_PullUp,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_SataLedActive,
        PinmuxOpt_Gpio |
            PinmuxOpt_Output,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir
    },
    {
        PinmuxPadIndex_Sdmmc3Clk,
        PinmuxOpt_Gpio |
            PinmuxOpt_Input |
            PinmuxOpt_PullDown,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_Sdmmc3Dat0,
        PinmuxOpt_Gpio |
            PinmuxOpt_Input |
            PinmuxOpt_NoPupd,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_Sdmmc3Dat1,
        PinmuxOpt_Gpio |
            PinmuxOpt_Input |
            PinmuxOpt_NoPupd,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_Sdmmc3Dat2,
        PinmuxOpt_Gpio |
            PinmuxOpt_Input |
            PinmuxOpt_NoPupd,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_Sdmmc3Dat3,
        PinmuxOpt_Gpio |
            PinmuxOpt_Input |
            PinmuxOpt_NoPupd,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_TempAlert,
        PinmuxOpt_Gpio |
            PinmuxOpt_Input |
            PinmuxOpt_PullUp,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_MotionInt,
        PinmuxOpt_Gpio |
            PinmuxOpt_Input |
            PinmuxOpt_PullDown,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_TouchRst,
        PinmuxOpt_Gpio |
            PinmuxOpt_Input |
            PinmuxOpt_NoPupd,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_TouchInt,
        PinmuxOpt_Gpio |
            PinmuxOpt_Input |
            PinmuxOpt_PullUp,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_ButtonPowerOn,
        PinmuxOpt_Gpio |
            PinmuxOpt_Input |
            PinmuxOpt_PullUp,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_ButtonVolUp,
        PinmuxOpt_Gpio |
            PinmuxOpt_Input |
            PinmuxOpt_PullUp,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_ButtonVolDown,
        PinmuxOpt_Gpio |
            PinmuxOpt_Input |
            PinmuxOpt_PullUp,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_ButtonSlideSw,
        PinmuxOpt_Gpio |
            PinmuxOpt_Input |
            PinmuxOpt_PullUp,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_ButtonHome,
        PinmuxOpt_Gpio |
            PinmuxOpt_Input |
            PinmuxOpt_NoPupd,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_LcdBlEn,
        PinmuxOpt_Gpio |
            PinmuxOpt_Output,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir
    },
    {
        PinmuxPadIndex_LcdRst,
        PinmuxOpt_Gpio |
            PinmuxOpt_Output,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir
    },
    {
        PinmuxPadIndex_ApReady,
        PinmuxOpt_Gpio |
            PinmuxOpt_Output,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir
    },
    {
        PinmuxPadIndex_GpioPz0,
        PinmuxOpt_Gpio |
            PinmuxOpt_Input |
            PinmuxOpt_PullUp,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_GpioPz1,
        PinmuxOpt_Gpio |
            PinmuxOpt_Input |
            PinmuxOpt_PullUp,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_GpioPz2,
        PinmuxOpt_Gpio |
            PinmuxOpt_Input |
            PinmuxOpt_PullDown,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_GpioPz3,
        PinmuxOpt_Gpio |
            PinmuxOpt_Input |
            PinmuxOpt_PullUp,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_GpioPz4,
        PinmuxOpt_Gpio |
            PinmuxOpt_Output,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir
    },
    {
        PinmuxPadIndex_Dap4Din,
        PinmuxOpt_Gpio |
            PinmuxOpt_Output,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir
    },
    {
        PinmuxPadIndex_Dap4Sclk,
        PinmuxOpt_Gpio |
            PinmuxOpt_Output,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir
    },
    {
        PinmuxPadIndex_Uart2Tx,
        PinmuxOpt_Gpio |
            PinmuxOpt_Input |
            PinmuxOpt_NoPupd,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_GpioPk0,
        PinmuxOpt_Gpio |
            PinmuxOpt_Bidirection |
            PinmuxOpt_PullDown,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_GpioPk1,
        PinmuxOpt_Gpio |
            PinmuxOpt_Bidirection |
            PinmuxOpt_PullDown,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_GpioPk2,
        PinmuxOpt_Gpio |
            PinmuxOpt_Bidirection |
            PinmuxOpt_NoPupd,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_GpioPk3,
        PinmuxOpt_Gpio |
            PinmuxOpt_Output,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir
    },
    {
        PinmuxPadIndex_GpioPk4,
        PinmuxOpt_Gpio |
            PinmuxOpt_Input |
            PinmuxOpt_PullUp,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_GpioPk5,
        PinmuxOpt_Gpio |
            PinmuxOpt_Output,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir
    },
    {
        PinmuxPadIndex_GpioPk6,
        PinmuxOpt_Gpio |
            PinmuxOpt_Input |
            PinmuxOpt_PullUp,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_GpioPk7,
        PinmuxOpt_Gpio |
            PinmuxOpt_Input |
            PinmuxOpt_PullUp,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_GpioPl0,
        PinmuxOpt_Gpio |
            PinmuxOpt_Output,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir
    },
    {
        PinmuxPadIndex_Uart3Tx,
        PinmuxOpt_Gpio |
            PinmuxOpt_Input |
            PinmuxOpt_NoPupd,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_WifiEn,
        PinmuxOpt_Gpio |
            PinmuxOpt_Output,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir
    },
    {
        PinmuxPadIndex_WifiRst,
        PinmuxOpt_Gpio |
            PinmuxOpt_Output,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir
    },
    {
        PinmuxPadIndex_WifiWakeAp,
        PinmuxOpt_Gpio |
            PinmuxOpt_Input |
            PinmuxOpt_PullDown,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_ApWakeBt,
        PinmuxOpt_Gpio |
            PinmuxOpt_Output,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir
    },
    {
        PinmuxPadIndex_BtRst,
        PinmuxOpt_Gpio |
            PinmuxOpt_Output,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir
    },
    {
        PinmuxPadIndex_BtWakeAp,
        PinmuxOpt_Gpio |
            PinmuxOpt_Input |
            PinmuxOpt_NoPupd,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_GpioPh6,
        PinmuxOpt_Gpio |
            PinmuxOpt_Input |
            PinmuxOpt_NoPupd,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_ApWakeNfc,
        PinmuxOpt_Gpio |
            PinmuxOpt_Output |
            PinmuxOpt_NoPupd,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_NfcEn,
        PinmuxOpt_Gpio |
            PinmuxOpt_Output,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir
    },
    {
        PinmuxPadIndex_NfcInt,
        PinmuxOpt_Gpio |
            PinmuxOpt_Output,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir
    },
    {
        PinmuxPadIndex_SpdifOut,
        PinmuxOpt_Gpio |
            PinmuxOpt_Input |
            PinmuxOpt_PullUp,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_Pupd
    },
    {
        PinmuxPadIndex_SpdifIn,
        PinmuxOpt_Gpio |
            PinmuxOpt_Output,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir
    },
    {
        PinmuxPadIndex_UsbVbusEn0,
        PinmuxOpt_Gpio |
            PinmuxOpt_Output |
            PinmuxOpt_NormalVoltage,
        PinmuxOptBitMask_Pm |
            PinmuxOptBitMask_Dir |
            PinmuxOptBitMask_IoHv
    },

    /*
     * Unused pinmux
     */
    {
        PinmuxPadIndex_DvfsPwm,
        PinmuxOpt_Unused,
        PinmuxOptBitMask_Pm
    },
    {
        PinmuxPadIndex_Spi2Mosi,
        PinmuxOpt_Unused,
        PinmuxOptBitMask_Pm
    },
    {
        PinmuxPadIndex_Spi2Miso,
        PinmuxOpt_Unused,
        PinmuxOptBitMask_Pm
    },
    {
        PinmuxPadIndex_Spi2Sck,
        PinmuxOpt_Unused,
        PinmuxOptBitMask_Pm
    },
    {
        PinmuxPadIndex_Spi2Cs0,
        PinmuxOpt_Unused,
        PinmuxOptBitMask_Pm
    },
    {
        PinmuxPadIndex_Spi2Cs1,
        PinmuxOpt_Unused,
        PinmuxOptBitMask_Pm
    },
    {
        PinmuxPadIndex_Dmic1Clk,
        PinmuxOpt_Unused,
        PinmuxOptBitMask_Pm
    },
    {
        PinmuxPadIndex_Dmic1Dat,
        PinmuxOpt_Unused,
        PinmuxOptBitMask_Pm
    },
    {
        PinmuxPadIndex_Dmic2Clk,
        PinmuxOpt_Unused,
        PinmuxOptBitMask_Pm
    },
    {
        PinmuxPadIndex_Dmic2Dat,
        PinmuxOpt_Unused,
        PinmuxOptBitMask_Pm
    },
    {
        PinmuxPadIndex_GpioPe7,
        PinmuxOpt_Unused,
        PinmuxOptBitMask_Pm
    },
    {
        PinmuxPadIndex_CamI2cScl,
        PinmuxOpt_Unused,
        PinmuxOptBitMask_Pm
    },
    {
        PinmuxPadIndex_CamRst,
        PinmuxOpt_Unused,
        PinmuxOptBitMask_Pm
    },
    {
        PinmuxPadIndex_CamAfEn,
        PinmuxOpt_Unused,
        PinmuxOptBitMask_Pm
    },
    {
        PinmuxPadIndex_Cam2Pwdn,
        PinmuxOpt_Unused,
        PinmuxOptBitMask_Pm
    },
    {
        PinmuxPadIndex_Cam1Strobe,
        PinmuxOpt_Unused,
        PinmuxOptBitMask_Pm
    },
    {
        PinmuxPadIndex_GpioPa6,
        PinmuxOpt_Unused,
        PinmuxOptBitMask_Pm
    },
    {
        PinmuxPadIndex_Sdmmc3Cmd,
        PinmuxOpt_Unused,
        PinmuxOptBitMask_Pm
    },
    {
        PinmuxPadIndex_AlsProxInt,
        PinmuxOpt_Unused,
        PinmuxOptBitMask_Pm
    },
    {
        PinmuxPadIndex_TouchClk,
        PinmuxOpt_Unused,
        PinmuxOptBitMask_Pm
    },
    {
        PinmuxPadIndex_ModemWakeAp,
        PinmuxOpt_Unused,
        PinmuxOptBitMask_Pm
    },
    {
        PinmuxPadIndex_LcdTe,
        PinmuxOpt_Unused,
        PinmuxOptBitMask_Pm
    },
    {
        PinmuxPadIndex_LcdGpio1,
        PinmuxOpt_Unused,
        PinmuxOptBitMask_Pm
    },
    {
        PinmuxPadIndex_ClkReq,
    },
    {
        PinmuxPadIndex_Dap4Dout,
        PinmuxOpt_Unused,
        PinmuxOptBitMask_Pm
    },
    {
        PinmuxPadIndex_Dap4Fs,
        PinmuxOpt_Unused,
        PinmuxOptBitMask_Pm
    },
    {
        PinmuxPadIndex_Spi1Mosi,
        PinmuxOpt_Unused,
        PinmuxOptBitMask_Pm
    },
    {
        PinmuxPadIndex_Spi1Miso,
        PinmuxOpt_Unused,
        PinmuxOptBitMask_Pm
    },
    {
        PinmuxPadIndex_Spi1Sck,
        PinmuxOpt_Unused,
        PinmuxOptBitMask_Pm
    },
    {
        PinmuxPadIndex_Spi1Cs0,
        PinmuxOpt_Unused,
        PinmuxOptBitMask_Pm
    },
    {
        PinmuxPadIndex_Spi1Cs1,
        PinmuxOpt_Unused,
        PinmuxOptBitMask_Pm
    },
    {
        PinmuxPadIndex_GpsEn,
        PinmuxOpt_Unused,
        PinmuxOptBitMask_Pm
    },
    {
        PinmuxPadIndex_GpsRst,
        PinmuxOpt_Unused,
        PinmuxOptBitMask_Pm
    },
    {
        PinmuxPadIndex_QspiIo2,
        PinmuxOpt_Unused,
        PinmuxOptBitMask_Pm
    },
    {
        PinmuxPadIndex_QspiIo3,
        PinmuxOpt_Unused,
        PinmuxOptBitMask_Pm
    },
    {
        PinmuxPadIndex_GpioPcc7,
        PinmuxOpt_Unused,
        PinmuxOptBitMask_Pm
    },
    {
        PinmuxPadIndex_UsbVbusEn1,
        PinmuxOpt_Unused,
        PinmuxOptBitMask_Pm
    },
    {
        PinmuxPadIndex_DpHpd0,
        PinmuxOpt_Unused,
        PinmuxOptBitMask_Pm
    },
    {
        PinmuxPadIndex_HdmiCec,
        PinmuxOpt_Unused,
        PinmuxOptBitMask_Pm
    },
};


} // tk2
} // tegra
} // pinmux
} // nne
