﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using nn;
using nn.sf;
using std;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;

namespace nn.ovln
{
    [ExternalStruct(128, 8)]
    [CppRefPath("<nn/ovln/ovln_ServiceTypes.h>")]
    public struct RawMessage
    {
    }

    [ExternalStruct(8, 4)]
    [CppRefPath("<nn/ovln/ovln_ServiceTypes.h>")]
    public struct SendOption
    {
    }

    [CppRefPath("<nn/ovln/ovln_Services.sfdl.h>")]
    public interface ISender : IServiceObject
    {
        [MethodId(0)]
        Result Send(RawMessage message, SendOption option);

        [MethodId(1)]
        Result GetUnreceivedMessageCount(Out<uint32_t> pOut);
    }

    [ExternalStruct(16, 4)]
    [CppRefPath("<nn/ovln/ovln_ServiceTypes.h>")]
    public struct SourceName
    {
    }

    [ExternalStruct(8, 4)]
    [CppRefPath("<nn/ovln/ovln_ServiceTypes.h>")]
    public struct QueueAttribute
    {
    }

    [CppRefPath("<nn/ovln/ovln_Services.sfdl.h>")]
    public interface ISenderService : IServiceObject
    {
        [MethodId(0)]
        Result OpenSender(Out<ISender> pOut, SourceName sourceName, QueueAttribute queueAttribute);
    }

    [CppRefPath("<nn/ovln/ovln_Services.sfdl.h>")]
    public interface IReceiver : IServiceObject
    {
        [MethodId(0)]
        Result AddSource(SourceName sourceName);

        [MethodId(1)]
        Result RemoveSource(SourceName sourceName);

        [MethodId(2)]
        Result GetReceiveEventHandle(Out<NativeHandle> pOut);

        [MethodId(3)]
        Result Receive(Out<RawMessage> pMessage);

        [MethodId(4)]
        Result ReceiveWithTick(Out<RawMessage> pMessage, Out<int64_t> pOutTick);
    }

    [CppRefPath("<nn/ovln/ovln_Services.sfdl.h>")]
    public interface IReceiverService : IServiceObject
    {
        [MethodId(0)]
        Result OpenReceiver(Out<IReceiver> pOut);
    }
}
