﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ovln/ovln_ForDevelop.h>

#include <nn/nn_Allocator.h>
#include <nn/ovln/ovln_NotificationAgent.h>
#include <nn/sf/sf_ISharedObject.h>
#include <nn/util/util_Exchange.h>
#include <nn/sf/sf_DefaultAllocationPolicy.h>

namespace nn { namespace ovln {

#ifdef NN_OVLN_USES_DIRECT_AGENT
namespace {

NotificationAgent* g_pNotificationAgent;

}

namespace detail {

sf::SharedPointer<ISenderService> GetSenderServicePrepared() NN_NOEXCEPT
{
    NN_ABORT_UNLESS(g_pNotificationAgent, "Call PrepareSenderAndReceiverForDevelop() before this.");
    return ovln::GetSenderService(g_pNotificationAgent);
}

sf::SharedPointer<IReceiverService> GetReceiverServicePrepared() NN_NOEXCEPT
{
    NN_ABORT_UNLESS(g_pNotificationAgent, "Call PrepareSenderAndReceiverForDevelop() before this.");
    return ovln::GetReceiverService(g_pNotificationAgent);
}

}
#endif

void PrepareSenderAndReceiverForDevelop(MemoryResource* pMemoryResource) NN_NOEXCEPT
{
    #ifdef NN_OVLN_USES_DIRECT_AGENT
        NN_SDK_REQUIRES(!g_pNotificationAgent);
        g_pNotificationAgent = ovln::CreateNotificationAgent(pMemoryResource ? pMemoryResource : sf::GetNewDeleteMemoryResource());
    #else
        NN_UNUSED(pMemoryResource);
    #endif
}

void ReleasePreparedSenderAndReceiverForDevelop() NN_NOEXCEPT
{
    #ifdef NN_OVLN_USES_DIRECT_AGENT
        NN_SDK_REQUIRES(g_pNotificationAgent != nullptr);
        ovln::DestroyNotificationAgent(util::Exchange(&g_pNotificationAgent, nullptr));
    #endif
}

}}
