﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os/os_Config.h>
#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/os/os_UserExceptionHandlerCommon.h>
#include <nn/os/os_UserExceptionHandlerTypes.h>
#include <nn/os/os_UserExceptionHandlerApi.h>

#include "detail/os_Diag.h"
#include "detail/os_UserExceptionHandlerImpl.h"
#include "detail/os_DefaultUserExceptionHandlerImpl.h"

namespace nn { namespace os {

//-----------------------------------------------------------------------------
//  ユーザ例外ハンドラの設定
//
void SetUserExceptionHandler(UserExceptionHandler pHandler, void* stack, size_t stackSize, UserExceptionInfo* pExceptionInfo) NN_NOEXCEPT
{
    uintptr_t stackTop = reinterpret_cast<uintptr_t>(stack);

    if (pHandler == NULL)
    {
        // ハンドラ設定を解除
        detail::g_UserExceptionHandler     = NULL;
        detail::g_UserExceptionStackTop    = 0;
        detail::g_UserExceptionStackBottom = 0;
        detail::g_UserExceptionInfo        = NULL;
        return;
    }

    NN_SDK_REQUIRES( stackTop  % HandlerStackAlignment == 0 );
    NN_SDK_REQUIRES( stackSize % HandlerStackAlignment == 0 );

    detail::g_UserExceptionHandler     = pHandler;
    detail::g_UserExceptionStackTop    = stackTop;
    detail::g_UserExceptionStackBottom = stackTop + stackSize;
    detail::g_UserExceptionInfo        = pExceptionInfo;
}


//-----------------------------------------------------------------------------
//  ユーザ例外ハンドラの設定
//
void EnableUserExceptionHandlerOnDebugging(bool isEnabled) NN_NOEXCEPT
{
    detail::g_UserExceptionHandlerValidityOnDebugging = isEnabled;
}


//-----------------------------------------------------------------------------

}} // namespace nn::os

