﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/nn_TimeSpan.h>
#include <nn/os/os_Tick.h>
#include <nn/os/os_Macro.h>

#include <nnc/os/os_Tick.h>

#include "detail/os_Diag.h"
#include "detail/os_Common.h"

//--------------------------------------------------------------------------
//  C 言語用の定義
//--------------------------------------------------------------------------

NN_OS_EXTERN_C nnosTick  nnosGetSystemTick()
{
    return nn::os::GetSystemTick().GetInt64Value();
}

NN_OS_EXTERN_C int64_t nnosGetSystemTickFrequency()
{
    return nn::os::GetSystemTickFrequency();
}

NN_OS_EXTERN_C int64_t  nnosConvertTickToNanoSeconds(nnosTick tick)
{
    return nn::os::ConvertToTimeSpan( nn::os::Tick(tick) ).GetNanoSeconds();
}

NN_OS_EXTERN_C nnosTick    nnosConvertNanoSecondsToTick(int64_t nanoSeconds)
{
    return nn::os::ConvertToTick( nn::TimeSpan::FromNanoSeconds(nanoSeconds) ).GetInt64Value();
}
