﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_TimeSpan.h>

#include <nn/os/os_Macro.h>
#include <nn/os/os_SemaphoreTypes.h>
#include <nn/os/os_SemaphoreApi.h>

#include <nnc/os/os_Macro.h>
#include <nnc/os/os_SemaphoreTypes.h>
#include <nnc/os/os_SemaphoreApi.h>

#include "detail/os_Diag.h"
#include "detail/os_Common.h"

//---------------------------------------------------------------------------
//  C++ 用の型とサイズやアライメントが一致しているのかをチェック
//---------------------------------------------------------------------------

static_assert(sizeof(nnosSemaphoreType) == sizeof(nn::os::SemaphoreType), "");
static_assert(NN_ALIGNOF(nnosSemaphoreType) == NN_ALIGNOF(nn::os::SemaphoreType), "");


//--------------------------------------------------------------------------
//  C 関数の定義
//--------------------------------------------------------------------------

NN_OS_EXTERN_C void nnosInitializeSemaphore(nnosSemaphoreType* semaphore, int initialCount, int maxCount)
{
    nn::os::InitializeSemaphore(reinterpret_cast<nn::os::SemaphoreType*>(semaphore), initialCount, maxCount);
}

NN_OS_EXTERN_C void nnosFinalizeSemaphore(nnosSemaphoreType* semaphore)
{
    nn::os::FinalizeSemaphore(reinterpret_cast<nn::os::SemaphoreType*>(semaphore));
}

NN_OS_EXTERN_C void nnosAcquireSemaphore(nnosSemaphoreType* semaphore)
{
    nn::os::AcquireSemaphore(reinterpret_cast<nn::os::SemaphoreType*>(semaphore));
}

NN_OS_EXTERN_C bool nnosTryAcquireSemaphore(nnosSemaphoreType* semaphore)
{
    return nn::os::TryAcquireSemaphore(reinterpret_cast<nn::os::SemaphoreType*>(semaphore));
}

NN_OS_EXTERN_C bool nnosTimedAcquireSemaphore(nnosSemaphoreType* semaphore, int64_t timeout)
{
    return nn::os::TimedAcquireSemaphore(reinterpret_cast<nn::os::SemaphoreType*>(semaphore), nn::TimeSpan::FromNanoSeconds(timeout));
}

NN_OS_EXTERN_C void nnosReleaseSemaphore(nnosSemaphoreType* semaphore)
{
    nn::os::ReleaseSemaphore(reinterpret_cast<nn::os::SemaphoreType*>(semaphore));
}

NN_OS_EXTERN_C void nnosReleaseSemaphoreCount(nnosSemaphoreType* semaphore, int count)
{
    nn::os::ReleaseSemaphore(reinterpret_cast<nn::os::SemaphoreType*>(semaphore), count);
}

NN_OS_EXTERN_C int nnosGetCurrentSemaphoreCount(const nnosSemaphoreType* semaphore)
{
    return nn::os::GetCurrentSemaphoreCount(reinterpret_cast<const nn::os::SemaphoreType*>(semaphore));
}

NN_OS_EXTERN_C void nnosInitializeMultiWaitHolderForSemaphore(nnosMultiWaitHolderType* multiWaitHolder, nnosSemaphoreType* semaphore)
{
    nn::os::InitializeMultiWaitHolder(reinterpret_cast<nn::os::MultiWaitHolderType*>(multiWaitHolder), reinterpret_cast<nn::os::SemaphoreType*>(semaphore));
}
