﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_TimeSpan.h>

#include <nn/os/os_Macro.h>
#include <nn/os/os_MessageQueueTypes.h>
#include <nn/os/os_MessageQueueApi.h>
#include <nn/os/os_MultipleWaitCommon.h>

#include <nnc/os/os_Macro.h>
#include <nnc/os/os_MessageQueueTypes.h>
#include <nnc/os/os_MessageQueueApi.h>

//---------------------------------------------------------------------------
//  C++ 用の型とサイズやアライメントが一致しているのかをチェック
//---------------------------------------------------------------------------

static_assert(sizeof(nnosMessageQueueType) == sizeof(nn::os::MessageQueueType), "");
static_assert(NN_ALIGNOF(nnosMessageQueueType) == NN_ALIGNOF(nn::os::MessageQueueType), "");

static_assert(static_cast<int>(nnosMessageQueueWaitType_WaitForNotFull)  == static_cast<int>(nn::os::MessageQueueWaitType_WaitForNotFull), "");
static_assert(static_cast<int>(nnosMessageQueueWaitType_WaitForNotEmpty) == static_cast<int>(nn::os::MessageQueueWaitType_WaitForNotEmpty), "");


//---------------------------------------------------------------------------
//  C 関数の定義
//---------------------------------------------------------------------------

NN_OS_EXTERN_C void    nnosInitializeMessageQueue(nnosMessageQueueType* messageQueue, uintptr_t* buffer, size_t count)
{
    nn::os::InitializeMessageQueue(reinterpret_cast<nn::os::MessageQueueType*>(messageQueue), buffer, count);
}

NN_OS_EXTERN_C void    nnosFinalizeMessageQueue(nnosMessageQueueType* messageQueue)
{
    nn::os::FinalizeMessageQueue(reinterpret_cast<nn::os::MessageQueueType*>(messageQueue));
}

NN_OS_EXTERN_C void    nnosSendMessageQueue(nnosMessageQueueType* messageQueue, uintptr_t data)
{
    nn::os::SendMessageQueue(reinterpret_cast<nn::os::MessageQueueType*>(messageQueue), data);
}

NN_OS_EXTERN_C bool    nnosTrySendMessageQueue(nnosMessageQueueType* messageQueue, uintptr_t data)
{
    return nn::os::TrySendMessageQueue(reinterpret_cast<nn::os::MessageQueueType*>(messageQueue), data);
}

NN_OS_EXTERN_C bool    nnosTimedSendMessageQueue(nnosMessageQueueType* messageQueue, uintptr_t data, int64_t timeout)
{
    return nn::os::TimedSendMessageQueue(reinterpret_cast<nn::os::MessageQueueType*>(messageQueue), data, nn::TimeSpan::FromNanoSeconds(timeout));
}

NN_OS_EXTERN_C void    nnosJamMessageQueue(nnosMessageQueueType* messageQueue, uintptr_t data)
{
    nn::os::JamMessageQueue(reinterpret_cast<nn::os::MessageQueueType*>(messageQueue), data);
}

NN_OS_EXTERN_C bool    nnosTryJamMessageQueue(nnosMessageQueueType* messageQueue, uintptr_t data)
{
    return nn::os::TryJamMessageQueue(reinterpret_cast<nn::os::MessageQueueType*>(messageQueue), data);
}

NN_OS_EXTERN_C bool    nnosTimedJamMessageQueue(nnosMessageQueueType* messageQueue, uintptr_t data, int64_t timeout)
{
    return nn::os::TimedJamMessageQueue(reinterpret_cast<nn::os::MessageQueueType*>(messageQueue), data, nn::TimeSpan::FromNanoSeconds(timeout));
}

NN_OS_EXTERN_C void    nnosReceiveMessageQueue(uintptr_t* outData, nnosMessageQueueType* messageQueue)
{
    nn::os::ReceiveMessageQueue(outData, reinterpret_cast<nn::os::MessageQueueType*>(messageQueue));
}

NN_OS_EXTERN_C bool    nnosTryReceiveMessageQueue(uintptr_t* outData, nnosMessageQueueType* messageQueue)
{
    return nn::os::TryReceiveMessageQueue(outData, reinterpret_cast<nn::os::MessageQueueType*>(messageQueue));
}

NN_OS_EXTERN_C bool    nnosTimedReceiveMessageQueue(uintptr_t* outData, nnosMessageQueueType* messageQueue, int64_t timeout)
{
    return nn::os::TimedReceiveMessageQueue(outData, reinterpret_cast<nn::os::MessageQueueType*>(messageQueue), nn::TimeSpan::FromNanoSeconds(timeout));
}

NN_OS_EXTERN_C void    nnosPeekMessageQueue(uintptr_t* outData, const nnosMessageQueueType* messageQueue)
{
    nn::os::PeekMessageQueue(outData, reinterpret_cast<const nn::os::MessageQueueType*>(messageQueue));
}

NN_OS_EXTERN_C bool    nnosTryPeekMessageQueue(uintptr_t* outData, const nnosMessageQueueType* messageQueue)
{
    return nn::os::TryPeekMessageQueue(outData, reinterpret_cast<const nn::os::MessageQueueType*>(messageQueue));
}

NN_OS_EXTERN_C bool    nnosTimedPeekMessageQueue(uintptr_t* outData, const nnosMessageQueueType* messageQueue, int64_t timeout)
{
    return nn::os::TimedPeekMessageQueue(outData, reinterpret_cast<const nn::os::MessageQueueType*>(messageQueue), nn::TimeSpan::FromNanoSeconds(timeout));
}

NN_OS_EXTERN_C void    nnosInitializeMultiWaitHolderForMessageQueue(nnosMultiWaitHolderType* multiWaitHolder, nnosMessageQueueType* messageQueue, enum nnosMessageQueueWaitType waitType)
{
    nn::os::InitializeMultiWaitHolder(reinterpret_cast<nn::os::MultiWaitHolderType*>(multiWaitHolder), reinterpret_cast<nn::os::MessageQueueType*>(messageQueue), static_cast<nn::os::MessageQueueWaitType>(waitType));
}
