﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_TimeSpan.h>

#include <nn/os/os_Macro.h>
#include <nn/os/os_EventTypes.h>
#include <nn/os/os_EventApi.h>

#include <nnc/os/os_Macro.h>
#include <nnc/os/os_EventTypes.h>
#include <nnc/os/os_EventApi.h>
#include <nnc/os/os_EventCommon.h>

//---------------------------------------------------------------------------
//  C++ 用の型とサイズやアライメントが一致しているのかをチェック
//---------------------------------------------------------------------------

static_assert(sizeof(nnosEventType) == sizeof(nn::os::EventType), "");
static_assert(NN_ALIGNOF(nnosEventType) == NN_ALIGNOF(nn::os::EventType), "");

static_assert(static_cast<int>(nnosEventClearMode_ManualClear) == static_cast<int>(nn::os::EventClearMode_ManualClear), "");
static_assert(static_cast<int>(nnosEventClearMode_AutoClear)   == static_cast<int>(nn::os::EventClearMode_AutoClear), "");


//---------------------------------------------------------------------------
//  C 関数の定義
//---------------------------------------------------------------------------

NN_OS_EXTERN_C void nnosInitializeEvent(nnosEventType* event, bool initiallySignaled, nnosEventClearMode clearMode)
{
    nn::os::InitializeEvent( reinterpret_cast<nn::os::EventType*>(event),
                             initiallySignaled,
                             static_cast<nn::os::EventClearMode>(clearMode) );
}

NN_OS_EXTERN_C void nnosFinalizeEvent(nnosEventType* event)
{
    nn::os::FinalizeEvent(reinterpret_cast<nn::os::EventType*>(event));
}

NN_OS_EXTERN_C void nnosWaitEvent(nnosEventType* event)
{
    nn::os::WaitEvent(reinterpret_cast<nn::os::EventType*>(event));
}

NN_OS_EXTERN_C bool nnosTimedWaitEvent(nnosEventType* event, int64_t timeout)
{
    return nn::os::TimedWaitEvent( reinterpret_cast<nn::os::EventType*>(event),
                                   nn::TimeSpan::FromNanoSeconds(timeout) );
}

NN_OS_EXTERN_C bool nnosTryWaitEvent(nnosEventType* event)
{
    return nn::os::TryWaitEvent(reinterpret_cast<nn::os::EventType*>(event));
}

NN_OS_EXTERN_C void nnosSignalEvent(nnosEventType* event)
{
    nn::os::SignalEvent(reinterpret_cast<nn::os::EventType*>(event));
}

NN_OS_EXTERN_C void nnosClearEvent(nnosEventType* event)
{
    nn::os::ClearEvent(reinterpret_cast<nn::os::EventType*>(event));
}

NN_OS_EXTERN_C void nnosInitializeMultiWaitHolderForEvent(nnosMultiWaitHolderType* multiWaitHolder, nnosEventType* event)
{
    nn::os::InitializeMultiWaitHolder(reinterpret_cast<nn::os::MultiWaitHolderType*>(multiWaitHolder), reinterpret_cast<nn::os::EventType*>(event));
}
