﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/os/os_Config.h>
#include <nn/os/os_TickTypes.h>

#if defined(NN_BUILD_CONFIG_OS_HORIZON)
    #include "detail/os_DyingMessageImpl-os.horizon.h"
#else
    #include "detail/os_DyingMessageImpl-os.win32.h"
#endif

namespace nn { namespace os {

//-----------------------------------------------------------------------------
// ダイイング・メッセージ領域の設定
void SetDyingMessageRegion(uintptr_t address, size_t size) NN_NOEXCEPT
{
    NN_SDK_REQUIRES( address > 0 );
    NN_SDK_REQUIRES( address % nn::os::MemoryPageSize == 0 );
    NN_SDK_REQUIRES( size <= 4096 );

    detail::DyingMessageImpl::SetRegion(address, size);
}

//-----------------------------------------------------------------------------

}} // namespace nn::os

