﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SdkLog.h>
#include <nn/diag/text/diag_SdkTextOs.h>
#include <nn/os/os_Config.h>
#include <nn/os/os_DebugApi.h>
#include <nn/os/os_DebugTypes.h>
#include <nn/os/os_TickTypes.h>
#include <nn/os/os_MemoryHeapCommon.h>

#include "detail/os_Diag.h"
#include "detail/os_Common.h"
#include "detail/os_DebugImpl.h"


namespace nn { namespace os {

//-----------------------------------------------------------------------------
//  スタック情報の取得
void GetCurrentStackInfo(uintptr_t* outStack, size_t* outStackSize) NN_NOEXCEPT
{
    uintptr_t stackTop;
    size_t    stackSize;

    detail::DebugImpl::GetCurrentStackInfo(&stackTop, &stackSize);

    uintptr_t    sp = reinterpret_cast<uintptr_t>( &stackTop );
    NN_SDK_ASSERT( (stackTop <= sp) && (sp < (stackTop + stackSize)) );
    NN_UNUSED(sp);

    // 返値の設定（NULL なら返さない）
    if (outStack)
    {
        *outStack       = stackTop;
    }
    if (outStackSize)
    {
        *outStackSize   = stackSize;
    }
}

void GetCurrentStackInfoForDebug(uintptr_t* outStack, size_t* outStackSize) NN_NOEXCEPT
{
    NN_SDK_LOG("nn::os::GetCurrentStackInfoForDebug() is deprecated. Use nn::os::GetCurrentStackInfo() instead.\n");
    GetCurrentStackInfo(outStack, outStackSize);
}

//-----------------------------------------------------------------------------
//  メモリ情報の取得
void QueryMemoryInfo(MemoryInfo* info) NN_NOEXCEPT
{
    detail::DebugImpl::QueryMemoryInfo(info);
}

void QueryMemoryInfoForDebug(MemoryInfo* info) NN_NOEXCEPT
{
    NN_SDK_LOG("nn::os::QueryMemoryInfoForDebug() is deprecated. Use nn::os::QueryMemoryInfo() instead.\n");
    detail::DebugImpl::QueryMemoryInfo(info);
}

//-----------------------------------------------------------------------------
//  自コアの CPU アイドル時間の取得
Tick GetIdleTickCount() NN_NOEXCEPT
{
    return detail::DebugImpl::GetIdleTickCount();
}

//-----------------------------------------------------------------------------
//  指定されたアドレス空間が全て MemoryAttribute_None かどうかを検査
bool IsMemoryLocked(uintptr_t address, size_t size) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(size > 0);

#if defined(NN_BUILD_CONFIG_OS_HORIZON)
    return !detail::ExamineWholeAddressSpaceHasNoAttribute(address, size);
#else
    NN_UNUSED(address);
    NN_UNUSED(size);
    NN_ABORT("%s: Not supported.", NN_CURRENT_FUNCTION_NAME);
#endif
}

bool IsMemoryLocked(void* address, size_t size) NN_NOEXCEPT
{
    return IsMemoryLocked(reinterpret_cast<uintptr_t>(address), size);
}

//-----------------------------------------------------------------------------

}} // namespace nn::os

