﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_TimeSpan.h>

#include <nn/os/os_Macro.h>
#include <nn/os/os_MutexTypes.h>
#include <nn/os/os_ConditionVariableCommon.h>
#include <nn/os/os_ConditionVariableTypes.h>
#include <nn/os/os_ConditionVariableApi.h>

#include <nnc/os/os_Macro.h>
#include <nnc/os/os_MutexTypes.h>
#include <nnc/os/os_ConditionVariableCommon.h>
#include <nnc/os/os_ConditionVariableTypes.h>
#include <nnc/os/os_ConditionVariableApi.h>

#include "detail/os_Diag.h"
#include "detail/os_Common.h"

//---------------------------------------------------------------------------
//  C++ 用の型とサイズやアライメントが一致しているのかをチェック
//---------------------------------------------------------------------------

static_assert(sizeof(nnosConditionVariableType) == sizeof(nn::os::ConditionVariableType), "");
static_assert(NN_ALIGNOF(nnosConditionVariableType) == NN_ALIGNOF(nn::os::ConditionVariableType), "");

static_assert(static_cast<int>(nnosConditionVariableStatus_NoTimeout) == static_cast<int>(nn::os::ConditionVariableStatus_NoTimeout), "");
static_assert(static_cast<int>(nnosConditionVariableStatus_Timeout) == static_cast<int>(nn::os::ConditionVariableStatus_Timeout), "");

//---------------------------------------------------------------------------
// C 関数の定義
//---------------------------------------------------------------------------

NN_OS_EXTERN_C void nnosInitializeConditionVariable(nnosConditionVariableType* conditionVariable)
{
    nn::os::InitializeConditionVariable(reinterpret_cast<nn::os::ConditionVariableType*>(conditionVariable));
}

NN_OS_EXTERN_C void nnosFinalizeConditionVariable(nnosConditionVariableType* conditionVariable)
{
    nn::os::FinalizeConditionVariable(reinterpret_cast<nn::os::ConditionVariableType*>(conditionVariable));
}

NN_OS_EXTERN_C void nnosSignalConditionVariable(nnosConditionVariableType* conditionVariable)
{
    nn::os::SignalConditionVariable(reinterpret_cast<nn::os::ConditionVariableType*>(conditionVariable));
}

NN_OS_EXTERN_C void nnosBroadcastConditionVariable(nnosConditionVariableType* conditionVariable)
{
    nn::os::BroadcastConditionVariable(reinterpret_cast<nn::os::ConditionVariableType*>(conditionVariable));
}

NN_OS_EXTERN_C void nnosWaitConditionVariable(nnosConditionVariableType* conditionVariable, nnosMutexType *mutex)
{
    nn::os::WaitConditionVariable(
        reinterpret_cast<nn::os::ConditionVariableType*>(conditionVariable),
        reinterpret_cast<nn::os::MutexType*>(mutex));
}

NN_OS_EXTERN_C nnosConditionVariableStatus nnosTimedWaitConditionVariable(nnosConditionVariableType* conditionVariable, nnosMutexType *mutex, int64_t timeout)
{
    auto result = nn::os::TimedWaitConditionVariable(
        reinterpret_cast<nn::os::ConditionVariableType*>(conditionVariable),
        reinterpret_cast<nn::os::MutexType*>(mutex),
        nn::TimeSpan::FromNanoSeconds(timeout));

    return static_cast<nnosConditionVariableStatus>( result );
}

