﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "detail/os_Common.h"

#include <nn/os/os_Config.h>
#include <nn/diag/text/diag_SdkTextOs.h>
#include <nn/nn_Common.h>

#include <nn/os/os_Barrier.h>
#include <nn/os/os_ConditionVariable.h>
#include <nn/os/os_InterruptEvent.h>
#include <nn/os/os_MessageQueue.h>
#include <nn/os/os_MultipleWait.h>
#include <nn/os/os_Semaphore.h>
#include <nn/os/os_SharedMemory.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/os/os_Thread.h>
#include <nn/os/os_Tick.h>
#include <nn/os/os_TimerEvent.h>
#include <nn/os/os_TransferMemory.h>
#include <nn/os/os_UserExceptionHandler.h>

#include <nn/os/detail/os_TypesDefinition.h>

namespace {

//-----------------------------------------------------------------------------
//  指定された type のサイズとアライメントをビルド時にエラーダンプするマクロ
//-----------------------------------------------------------------------------

template <typename T, int, int>
struct type_;

#define NN_OS_DUMP_SIZE(type)  \
        inline void sizeof_(type_<type, sizeof(type), NN_ALIGNOF(type)>) {}

//-----------------------------------------------------------------------------
//  以下のコードを有効にすると、必ずコンパイルエラーになります。
//
//  コンパイルエラーの際、各構造体のサイズとアライメントを同時に出力するため、
//  そのログをメモすることで、構造体のサイズとアライメント情報を取得できます。
//
//  clang および gcc の場合は、全ての構造体について一気にエラーメッセージを
//  出力します。VC++ 環境では、最初のエラーメッセージのみ出力されるため、
//  VC++ 環境で試す場合には、確認したい構造体以外はコメントアウトする必要が
//  あります。
//-----------------------------------------------------------------------------
#if 0

NN_OS_DUMP_SIZE(nn::os::ThreadType)
NN_OS_DUMP_SIZE(nn::os::SemaphoreType)
NN_OS_DUMP_SIZE(nn::os::MessageQueueType)
NN_OS_DUMP_SIZE(nn::os::EventType)
NN_OS_DUMP_SIZE(nn::os::TimerEventType)
NN_OS_DUMP_SIZE(nn::os::InterruptEventType)
NN_OS_DUMP_SIZE(nn::os::SystemEventType)
NN_OS_DUMP_SIZE(nn::os::MultiWaitType)
NN_OS_DUMP_SIZE(nn::os::MultiWaitHolderType)

NN_OS_DUMP_SIZE(nn::os::MutexType)
NN_OS_DUMP_SIZE(nn::os::ConditionVariableType)
NN_OS_DUMP_SIZE(nn::os::BarrierType)

NN_OS_DUMP_SIZE(nn::os::TransferMemoryType)
NN_OS_DUMP_SIZE(nn::os::SharedMemoryType)

NN_OS_DUMP_SIZE(nn::os::UserExceptionInfo)

NN_OS_DUMP_SIZE(nn::os::Tick)
NN_OS_DUMP_SIZE(nn::TimeSpan)

NN_OS_DUMP_SIZE(nn::os::detail::InternalCriticalSection)
NN_OS_DUMP_SIZE(nn::os::detail::InternalConditionVariable)

#endif

//-----------------------------------------------------------------------------
//  サイズ の静的チェック
//-----------------------------------------------------------------------------

#define NN_OS_CHECK_SIZE(type, size)   \
        static_assert(sizeof(type) == size, "サイズが異なっています");


NN_OS_CHECK_SIZE(nn::os::ThreadType, NN_OS_SIZEOF_THREAD_TYPE);
NN_OS_CHECK_SIZE(nn::os::SemaphoreType, NN_OS_SIZEOF_SEMAPHORE_TYPE);
NN_OS_CHECK_SIZE(nn::os::MessageQueueType, NN_OS_SIZEOF_MESSAGE_QUEUE_TYPE);
NN_OS_CHECK_SIZE(nn::os::EventType, NN_OS_SIZEOF_EVENT_TYPE);
NN_OS_CHECK_SIZE(nn::os::TimerEventType, NN_OS_SIZEOF_TIMER_EVENT_TYPE);
NN_OS_CHECK_SIZE(nn::os::InterruptEventType, NN_OS_SIZEOF_INTERRUPT_EVENT_TYPE);
NN_OS_CHECK_SIZE(nn::os::SystemEventType, NN_OS_SIZEOF_SYSTEM_EVENT_TYPE);
NN_OS_CHECK_SIZE(nn::os::MultiWaitType, NN_OS_SIZEOF_MULTI_WAIT_TYPE);
NN_OS_CHECK_SIZE(nn::os::MultiWaitHolderType, NN_OS_SIZEOF_MULTI_WAIT_HOLDER_TYPE);

NN_OS_CHECK_SIZE(nn::os::MutexType, NN_OS_SIZEOF_MUTEX_TYPE);
NN_OS_CHECK_SIZE(nn::os::ConditionVariableType, NN_OS_SIZEOF_CONDITION_VARIABLE_TYPE);
NN_OS_CHECK_SIZE(nn::os::BarrierType, NN_OS_SIZEOF_BARRIER_TYPE);

//-----------------------------------------------------------------------------

}   // namespace

