﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os/os_Config.h>
#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/os/os_UserExceptionHandlerCommon.h>
#include <nn/os/os_UserExceptionHandlerTypes.h>

namespace nn { namespace os { namespace detail {

//-----------------------------------------------------------------------------
//  ユーザ例外ハンドラで使用するグローバル変数
//
extern UserExceptionHandler g_UserExceptionHandler;
extern uintptr_t            g_UserExceptionStackTop;
extern uintptr_t            g_UserExceptionStackBottom;
extern UserExceptionInfo*   g_UserExceptionInfo;
extern bool                 g_UserExceptionHandlerValidityOnDebugging;

//-----------------------------------------------------------------------------

}}} // namespace nn::os::detail

