﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os/os_Config.h>
#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_BitTypes.h>
#include <nn/os/os_UserExceptionHandlerCommon.h>
#include <nn/os/os_UserExceptionHandlerTypes.h>

#include <nn/svc/svc_Types.h>


namespace nn { namespace os { namespace detail {

//-----------------------------------------------------------------------------
// 例外発生直後の nn::svc::ExceptionInfo 構造体や他の情報を受け取り、
// nn::os:UserExceptionInfo 構造体へ情報をコピーする準備を行なう。
//
UserExceptionInfoDetail* PrepareToCopyUserExceptionInfo(
                            Bit32               exceptionType,
                            svc::ExceptionInfo* pSvcExceptionInfo) NN_NOEXCEPT;

//-----------------------------------------------------------------------------

}}} // namespace nn::os::detail

