﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os/os_Config.h>

#include <nn/nn_SdkAssert.h>
#include <nn/nn_Macro.h>
#include <nn/nn_TimeSpan.h>
#include <nn/os/os_Tick.h>

#include "os_Common.h"
#include "os_TimeoutHelper.h"

//--------------------------------------------------------------------------

namespace nn { namespace os {
namespace detail {

//--------------------------------------------------------------------------
// タイムアウト成立までの残り時間をターゲット依存の時間型で返す
// 既にタイムアウトが成立している場合は 0 を返す
InternalTargetTimeSpan TimeoutHelper::GetLeftTimeOnTarget() const NN_NOEXCEPT
{
    // m_absoluteEndTick==0 なら必ずタイムアウト成立
    if (m_absoluteEndTick.GetInt64Value() == 0)
    {
        return 0;
    }

    // 現在時間を取得
    Tick  currTick = detail::GetTickManagerInstance()->GetTick();

    // 既にタイムアウト成立であれば 0 を返す
    if (currTick >= m_absoluteEndTick)
    {
        return 0;
    }

    // タイムアウト成立までの時間差分を変換して返す
    return  TimeoutHelperImpl::ConvertToImplTime( m_absoluteEndTick - currTick );
}

}   // namespace detail
}}  // namespace nn::os

