﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/nn_Macro.h>
#include <nn/svc/svc_Thread.h>
#include <nn/svc/svc_MemoryMapSelect.h>


namespace nn { namespace os {
namespace detail {

//--------------------------------------------------------------------------

class StackGuardManagerImplByHorizon
{
private:
    static uint64_t GetStackInfo(svc::InfoType type)
    {
        Bit64 value;
        auto result = svc::GetInfo(&value,
                                   type,
                                   svc::PSEUDO_HANDLE_CURRENT_PROCESS,
                                   0);
        NN_ABORT_UNLESS_RESULT_SUCCESS(result);
        NN_SDK_ASSERT(value <= SIZE_MAX);
        return static_cast<uint64_t>(value & SIZE_MAX);
    }

public:
    static uint64_t GetStackGuardBeginAddress() NN_NOEXCEPT
    {
        return GetStackInfo(svc::InfoType_StackRegionAddress);
    }
    static uint64_t GetStackGuardEndAddress() NN_NOEXCEPT
    {
        return GetStackInfo(svc::InfoType_StackRegionAddress) + GetStackInfo(svc::InfoType_StackRegionSize);
    }
};

typedef StackGuardManagerImplByHorizon StackGuardManagerImpl;

//--------------------------------------------------------------------------

}  // namespace detail
}} // namespace nn::os

