﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_TimeSpan.h>
#include <nn/os/os_NativeHandleTypes.h>

#include <nn/svc/svc_Base.h>
#include <nn/svc/svc_Synchronization.h>
#include <nn/svc/svc_Handle.h>

#include "os_MultipleWaitHelper.h"
#include "os_ThreadManager.h"

namespace nn { namespace os {
namespace detail {

//--------------------------------------------------------------------------
//  MultiWaitImplByHorizon クラス
//

class   MultiWaitImplByHorizon
{
public:
    static const int NativeHandleArrayCountMax = nn::svc::ArgumentHandleCountMax;

private:
    int  WaitSynchronizationN(int num, NativeHandle array[], int arraySize, int64_t nano) NN_NOEXCEPT;

public:
    // メンバ関数
    void CancelWait()   NN_NOEXCEPT;

    int WaitAny(NativeHandle array[], int arraySize, int num) NN_NOEXCEPT
    {
        return WaitSynchronizationN( num, array, arraySize, nn::svc::WAIT_INFINITE );
    }

    int TryWaitAny(NativeHandle array[], int arraySize, int num) NN_NOEXCEPT
    {
        return WaitSynchronizationN( num, array, arraySize, 0 );
    }

    int TimedWaitAny(NativeHandle array[], int arraySize, int num, TimeSpan timeSpan) NN_NOEXCEPT
    {
        int64_t timeout = timeSpan.GetNanoSeconds();

        // WaitAny では timeout < 0 の場合は無限待ちとなるため負の場合は 0 にする
        if (timeout < 0)
        {
            timeout = 0;
        }
        return WaitSynchronizationN( num, array, arraySize, timeout );
    }

    void SetCurrentThreadHandleForCancelWait() NN_NOEXCEPT
    {
        // 今から待機するカレントスレッドのハンドルを設定しておく
        m_Handle = svc::Handle( detail::GetCurrentThread()->_handle );
    }

    void ClearCurrentThreadHandleForCancelWait() NN_NOEXCEPT
    {
        m_Handle = svc::INVALID_HANDLE_VALUE;
    }

private:
    nn::svc::Handle     m_Handle;           // スレッドのハンドル
};

typedef MultiWaitImplByHorizon  MultiWaitImplByTarget;


}   // namespace detail
}}  // namespace nn::os

