﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>

#include "os_MemoryHeapManagerTypes.h"
#include "os_OsResourceManager.h"

namespace nn { namespace os {
namespace detail {

//---------------------------------------------------------------------------
// MemoryHeapManager のインスタンスを取得する
inline  MemoryHeapManager*  GetMemoryHeapManagerInstance() NN_NOEXCEPT
{
    return &GetOsResourceManagerStorage()->memoryHeapManager;
}

//---------------------------------------------------------------------------
// アライメントチェック
inline bool IsAligned(uintptr_t value, size_t alignmentSize) NN_NOEXCEPT
{
    return (value & (alignmentSize - 1)) == 0 ? true : false;
}

//---------------------------------------------------------------------------

}   // namespace detail
}}  // namespace nn::os

