﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "os_Common.h"

#include <nn/os/os_Config.h>

#if !defined(NN_BUILD_CONFIG_OS_SUPPORTS_WIN32)
    #error "OS 種別として Win32 が指定されていません。"
#endif

#include <nn/nn_Windows.h>
#include <nn/nn_Macro.h>
#include <nn/util/util_TypedStorage.h>
#include <nn/os/detail/os_InternalCriticalSection-os.win32.h>

#include "os_ThreadManager.h"
#include "os_InternalCriticalSectionTypes-os.win32.h"

//--------------------------------------------------------------------------

namespace nn { namespace os {
namespace detail {

//--------------------------------------------------------------------------
InternalCriticalSectionImplByWin32::InternalCriticalSectionImplByWin32() NN_NOEXCEPT
{
    Initialize();
}

//--------------------------------------------------------------------------
void InternalCriticalSectionImplByWin32::Initialize() NN_NOEXCEPT
{
    // Win32 のクリティカルセクションの初期化
    ::InitializeCriticalSection( &Get(m_criticalSectionWin32).criticalSection );
}

//--------------------------------------------------------------------------
InternalCriticalSectionImplByWin32::~InternalCriticalSectionImplByWin32() NN_NOEXCEPT
{
    Finalize();
}

//--------------------------------------------------------------------------
void InternalCriticalSectionImplByWin32::Finalize() NN_NOEXCEPT
{
    // Win32 のクリティカルセクションの削除
    ::DeleteCriticalSection( &Get(m_criticalSectionWin32).criticalSection );
}

//--------------------------------------------------------------------------
void InternalCriticalSectionImplByWin32::Enter() NN_NOEXCEPT
{
    // Win32 のクリティカルセクションの取得
    ::EnterCriticalSection( &Get(m_criticalSectionWin32).criticalSection );
}

//--------------------------------------------------------------------------
bool InternalCriticalSectionImplByWin32::TryEnter() NN_NOEXCEPT
{
    // Win32 のクリティカルセクションの取得（ポーリング）
    BOOL result = ::TryEnterCriticalSection( &Get(m_criticalSectionWin32).criticalSection );
    return (result == 0) ? false : true;
}

//--------------------------------------------------------------------------
void InternalCriticalSectionImplByWin32::Leave() NN_NOEXCEPT
{
    // Win32 のクリティカルセクションの解放
    ::LeaveCriticalSection( &Get(m_criticalSectionWin32).criticalSection );
}

//--------------------------------------------------------------------------
bool InternalCriticalSectionImplByWin32::IsLockedByCurrentThread() const NN_NOEXCEPT
{
    NN_ABORT("Don't use this function on Windows environment because cannot support this.");
}

}   // namespace detail
}}  // namespace nn::os

